/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.control;

import com.couchbase.mock.CouchbaseMock;
import com.couchbase.mock.control.CommandStatus;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class MockCommand {
    @NotNull
    protected CommandStatus getResponse() {
        CommandStatus commandStatus = new CommandStatus();
        if (commandStatus == null) {
            MockCommand.$$$reportNull$$$0(0);
        }
        return commandStatus;
    }

    @NotNull
    public abstract CommandStatus execute(@NotNull CouchbaseMock var1, @NotNull Command var2, @NotNull JsonObject var3);

    public static void loadServers(@NotNull JsonObject payload, Set<Integer> enabledServers) {
        if (payload == null) {
            MockCommand.$$$reportNull$$$0(1);
        }
        if (payload.has("servers")) {
            JsonArray arr = payload.get("servers").getAsJsonArray();
            for (int ii = 0; ii < arr.size(); ++ii) {
                JsonElement e = arr.get(ii);
                enabledServers.add(e.getAsInt());
            }
        }
    }

    public static void loadBuckets(@NotNull CouchbaseMock mock, @NotNull JsonObject payload, Set<String> enabledBuckets) {
        if (mock == null) {
            MockCommand.$$$reportNull$$$0(2);
        }
        if (payload == null) {
            MockCommand.$$$reportNull$$$0(3);
        }
        if (payload.has("bucket")) {
            enabledBuckets.add(payload.get("bucket").getAsString());
        } else {
            enabledBuckets.addAll(mock.getBuckets().keySet());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/couchbase/mock/control/MockCommand";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "payload";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponse";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/couchbase/mock/control/MockCommand";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadServers";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadBuckets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Command {
        FAILOVER,
        RESPAWN,
        HICCUP,
        TRUNCATE,
        MOCKINFO,
        PERSIST,
        CACHE,
        UNPERSIST,
        UNCACHE,
        ENDURE,
        PURGE,
        KEYINFO,
        TIME_TRAVEL,
        HELP,
        OPFAIL,
        SET_CCCP,
        GET_MCPORTS,
        REGEN_VBCOORDS,
        RESET_QUERYSTATE,
        START_CMDLOG,
        STOP_CMDLOG,
        GET_CMDLOG,
        START_RETRY_VERIFY,
        CHECK_RETRY_VERIFY,
        SET_ENHANCED_ERRORS,
        SET_QUERY_ERROR_STATE,
        SET_COMPRESSION,
        SET_SASL_MECHANISMS;

    }
}

