/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.client;

import com.couchbase.mock.client.AbstractMockClient;
import com.couchbase.mock.client.MockRequest;
import com.couchbase.mock.client.MockResponse;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;

public class MockClient
extends AbstractMockClient {
    private final InetSocketAddress listenAddress;
    private final ServerSocket serverSocket;
    private Socket clientSocket;
    private BufferedReader reader;
    private BufferedWriter writer;
    private int restPort;
    private volatile boolean isShutdown;

    public MockClient(@NotNull InetSocketAddress address) throws IOException {
        if (address == null) {
            MockClient.$$$reportNull$$$0(0);
        }
        this.clientSocket = null;
        this.reader = null;
        this.writer = null;
        this.restPort = -1;
        this.isShutdown = false;
        this.serverSocket = new ServerSocket(address.getPort(), 10);
        this.listenAddress = new InetSocketAddress(this.serverSocket.getInetAddress(), this.serverSocket.getLocalPort());
    }

    public InetSocketAddress getListeningAddress() {
        return this.listenAddress;
    }

    public InetSocketAddress getRestAddress() {
        return new InetSocketAddress(this.restPort);
    }

    public int getPort() {
        return this.listenAddress.getPort();
    }

    public int getRestPort() {
        return this.restPort;
    }

    @Override
    public void negotiate() throws IOException {
        char c;
        this.clientSocket = this.serverSocket.accept();
        this.reader = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
        this.writer = new BufferedWriter(new OutputStreamWriter(this.clientSocket.getOutputStream()));
        StringBuilder sb = new StringBuilder();
        while ((c = (char)this.reader.read()) != '\u0000') {
            sb.append(c);
        }
        this.restPort = Integer.parseInt(sb.toString());
    }

    private void sendRequest(MockRequest request) throws IOException {
        String encoded = new Gson().toJson(request.getMap());
        this.writer.write(encoded, 0, encoded.length());
        this.writer.write(10);
        this.writer.flush();
    }

    private MockResponse readResponse() throws IOException {
        String respLine = this.reader.readLine();
        return new MockResponse(respLine);
    }

    @Override
    @NotNull
    public MockResponse request(@NotNull MockRequest request) throws IOException {
        if (request == null) {
            MockClient.$$$reportNull$$$0(1);
        }
        this.sendRequest(request);
        MockResponse mockResponse = this.readResponse();
        if (mockResponse == null) {
            MockClient.$$$reportNull$$$0(2);
        }
        return mockResponse;
    }

    @Override
    public synchronized void shutdown() {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (this.clientSocket != null) {
            try {
                this.reader.close();
                this.writer.close();
                this.clientSocket.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "address";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/couchbase/mock/client/MockClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/couchbase/mock/client/MockClient";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "request";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

