/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.eventing;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.manager.eventing.AsyncEventingFunctionManager;
import com.couchbase.client.java.manager.eventing.EventingFunctionBucketBinding;
import com.couchbase.client.java.manager.eventing.EventingFunctionConstantBinding;
import com.couchbase.client.java.manager.eventing.EventingFunctionKeyspace;
import com.couchbase.client.java.manager.eventing.EventingFunctionSettings;
import com.couchbase.client.java.manager.eventing.EventingFunctionUrlBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Stability.Uncommitted
public class EventingFunction {
    private final String name;
    private final String code;
    private final EventingFunctionKeyspace sourceKeyspace;
    private final EventingFunctionKeyspace metadataKeyspace;
    private final EventingFunctionSettings settings;
    private final boolean enforceSchema;
    private final String version;
    private final int handlerUuid;
    private final String functionInstanceId;
    private final List<EventingFunctionBucketBinding> bucketBindings;
    private final List<EventingFunctionUrlBinding> urlBindings;
    private final List<EventingFunctionConstantBinding> constantBindings;

    public static EventingFunction create(String name, String code, EventingFunctionKeyspace sourceKeyspace, EventingFunctionKeyspace metadataKeyspace) {
        return EventingFunction.builder(name, code, sourceKeyspace, metadataKeyspace).build();
    }

    public static Builder builder(String name, String code, EventingFunctionKeyspace sourceKeyspace, EventingFunctionKeyspace metadataKeyspace) {
        return new Builder(name, code, sourceKeyspace, metadataKeyspace);
    }

    @Stability.Volatile
    public static EventingFunction fromFunction(byte[] encoded) {
        try {
            return AsyncEventingFunctionManager.decodeFunction(encoded);
        }
        catch (Exception ex) {
            throw new InvalidArgumentException("Could not decode function JSON", (Throwable)ex, null);
        }
    }

    @Stability.Volatile
    public static List<EventingFunction> fromExportedFunctions(byte[] encoded) {
        JsonNode encodedFunctions = Mapper.decodeIntoTree((byte[])encoded);
        if (!encodedFunctions.isArray()) {
            throw new InvalidArgumentException("The encoded JSON must be a JSON array of functions", null, null);
        }
        ArrayList<EventingFunction> functions = new ArrayList<EventingFunction>();
        for (JsonNode function : encodedFunctions) {
            functions.add(EventingFunction.fromFunction(Mapper.encodeAsBytes((Object)function)));
        }
        return functions;
    }

    private EventingFunction(Builder builder) {
        this.settings = builder.settings;
        this.name = builder.name;
        this.code = builder.code;
        this.sourceKeyspace = builder.sourceKeyspace;
        this.metadataKeyspace = builder.metadataKeyspace;
        this.bucketBindings = builder.bucketBindings;
        this.urlBindings = builder.urlBindings;
        this.constantBindings = builder.constantBindings;
        this.enforceSchema = builder.enforceSchema;
        this.handlerUuid = builder.handlerUuid;
        this.functionInstanceId = builder.functionInstanceId;
        this.version = builder.version;
    }

    public String name() {
        return this.name;
    }

    public String code() {
        return this.code;
    }

    public EventingFunctionKeyspace sourceKeyspace() {
        return this.sourceKeyspace;
    }

    public EventingFunctionKeyspace metadataKeyspace() {
        return this.metadataKeyspace;
    }

    public String version() {
        return this.version;
    }

    public boolean enforceSchema() {
        return this.enforceSchema;
    }

    public long handlerUuid() {
        return this.handlerUuid;
    }

    public String functionInstanceId() {
        return this.functionInstanceId;
    }

    public EventingFunctionSettings settings() {
        return this.settings;
    }

    public List<EventingFunctionBucketBinding> bucketBindings() {
        return this.bucketBindings;
    }

    public List<EventingFunctionUrlBinding> urlBindings() {
        return this.urlBindings;
    }

    public List<EventingFunctionConstantBinding> constantBindings() {
        return this.constantBindings;
    }

    public String toString() {
        return "EventingFunction{name='" + this.name + '\'' + ", code='" + this.code + '\'' + ", sourceKeyspace=" + this.sourceKeyspace + ", metadataKeyspace=" + this.metadataKeyspace + ", settings=" + this.settings + ", version='" + this.version + '\'' + ", enforceSchema=" + this.enforceSchema + ", handlerUuid=" + this.handlerUuid + ", functionInstanceId='" + this.functionInstanceId + '\'' + ", bucketBindings=" + this.bucketBindings + ", urlBindings=" + this.urlBindings + ", constantBindings=" + this.constantBindings + '}';
    }

    public static class Builder {
        private final String name;
        private final String code;
        private final EventingFunctionKeyspace sourceKeyspace;
        private final EventingFunctionKeyspace metadataKeyspace;
        private EventingFunctionSettings settings = EventingFunctionSettings.create();
        private boolean enforceSchema = false;
        private List<EventingFunctionBucketBinding> bucketBindings = new ArrayList<EventingFunctionBucketBinding>();
        private List<EventingFunctionUrlBinding> urlBindings = new ArrayList<EventingFunctionUrlBinding>();
        private List<EventingFunctionConstantBinding> constantBindings = new ArrayList<EventingFunctionConstantBinding>();
        private String version;
        private int handlerUuid;
        private String functionInstanceId;

        private Builder(String name, String code, EventingFunctionKeyspace sourceKeyspace, EventingFunctionKeyspace metadataKeyspace) {
            this.name = Validators.notNullOrEmpty((String)name, (String)"Name");
            this.code = Validators.notNullOrEmpty((String)code, (String)"Code");
            this.sourceKeyspace = (EventingFunctionKeyspace)Validators.notNull((Object)sourceKeyspace, (String)"SourceKeyspace");
            this.metadataKeyspace = (EventingFunctionKeyspace)Validators.notNull((Object)metadataKeyspace, (String)"MetadataKeyspace");
        }

        public Builder urlBindings(List<EventingFunctionUrlBinding> urlBindings) {
            this.urlBindings = new ArrayList<EventingFunctionUrlBinding>((Collection)Validators.notNull(urlBindings, (String)"EventingFunctionUrlBinding"));
            return this;
        }

        public Builder bucketBindings(List<EventingFunctionBucketBinding> bucketBindings) {
            this.bucketBindings = new ArrayList<EventingFunctionBucketBinding>((Collection)Validators.notNull(bucketBindings, (String)"EventingFunctionBucketBinding"));
            return this;
        }

        public Builder constantBindings(List<EventingFunctionConstantBinding> constantBindings) {
            this.constantBindings = new ArrayList<EventingFunctionConstantBinding>((Collection)Validators.notNull(constantBindings, (String)"EventingFunctionConstantBinding"));
            return this;
        }

        public Builder enforceSchema(boolean enforceSchema) {
            this.enforceSchema = enforceSchema;
            return this;
        }

        public Builder settings(EventingFunctionSettings settings) {
            this.settings = settings;
            return this;
        }

        Builder version(String version) {
            this.version = version;
            return this;
        }

        Builder handlerUuid(int handlerUuid) {
            this.handlerUuid = handlerUuid;
            return this;
        }

        Builder functionInstanceId(String functionInstanceId) {
            this.functionInstanceId = functionInstanceId;
            return this;
        }

        public EventingFunction build() {
            return new EventingFunction(this);
        }
    }
}

