/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.error.context.ReducedQueryErrorContext;
import com.couchbase.client.core.error.transaction.internal.CoreTransactionCommitAmbiguousException;
import com.couchbase.client.core.error.transaction.internal.CoreTransactionExpiredException;
import com.couchbase.client.core.error.transaction.internal.CoreTransactionFailedException;
import com.couchbase.client.core.msg.query.QueryRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.topology.NodeIdentifier;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.transactions.error.TransactionCommitAmbiguousException;
import com.couchbase.client.java.transactions.error.TransactionExpiredException;
import com.couchbase.client.java.transactions.error.TransactionFailedException;
import java.time.Duration;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class QueryAccessor {
    @Stability.Internal
    public static QueryRequest targetedQueryRequest(String statement, byte[] queryBytes, String clientContextId, @Nullable NodeIdentifier target, boolean readonly, RetryStrategy retryStrategy, Duration timeout, RequestSpan parentSpan, Core core) {
        Validators.notNullOrEmpty((String)statement, (String)"Statement", () -> new ReducedQueryErrorContext(statement));
        return new QueryRequest(timeout, core.context(), retryStrategy, core.context().authenticator(), statement, queryBytes, readonly, clientContextId, parentSpan, null, null, target);
    }

    public static RuntimeException convertCoreQueryError(Throwable err) {
        if (err instanceof CoreTransactionCommitAmbiguousException) {
            return new TransactionCommitAmbiguousException((CoreTransactionCommitAmbiguousException)err);
        }
        if (err instanceof CoreTransactionExpiredException) {
            return new TransactionExpiredException((CoreTransactionExpiredException)err);
        }
        if (err instanceof CoreTransactionFailedException) {
            return new TransactionFailedException((CoreTransactionFailedException)err);
        }
        if (err instanceof RuntimeException) {
            return (RuntimeException)err;
        }
        return new RuntimeException(err);
    }
}

