/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.ReactorOps;
import com.couchbase.client.java.manager.query.AsyncCollectionQueryIndexManager;
import com.couchbase.client.java.manager.query.BuildQueryIndexOptions;
import com.couchbase.client.java.manager.query.CreatePrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.CreateQueryIndexOptions;
import com.couchbase.client.java.manager.query.DropPrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.query.DropQueryIndexOptions;
import com.couchbase.client.java.manager.query.GetAllQueryIndexesOptions;
import com.couchbase.client.java.manager.query.QueryIndex;
import com.couchbase.client.java.manager.query.WatchQueryIndexesOptions;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Stability.Volatile
public class ReactiveCollectionQueryIndexManager {
    private final AsyncCollectionQueryIndexManager async;
    private final ReactorOps reactor;

    @Stability.Internal
    public ReactiveCollectionQueryIndexManager(ReactorOps reactor, AsyncCollectionQueryIndexManager async) {
        this.reactor = Objects.requireNonNull(reactor);
        this.async = Objects.requireNonNull(async);
    }

    public Mono<Void> createIndex(String indexName, Collection<String> fields) {
        return this.reactor.publishOnUserScheduler(() -> this.async.createIndex(indexName, fields));
    }

    public Mono<Void> createIndex(String indexName, Collection<String> fields, CreateQueryIndexOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.createIndex(indexName, fields, options));
    }

    public Mono<Void> createPrimaryIndex() {
        return this.reactor.publishOnUserScheduler(() -> this.async.createPrimaryIndex());
    }

    public Mono<Void> createPrimaryIndex(CreatePrimaryQueryIndexOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.createPrimaryIndex(options));
    }

    public Flux<QueryIndex> getAllIndexes() {
        return this.reactor.publishOnUserScheduler(Reactor.toFlux(() -> this.async.getAllIndexes()));
    }

    public Flux<QueryIndex> getAllIndexes(GetAllQueryIndexesOptions options) {
        return this.reactor.publishOnUserScheduler(Reactor.toFlux(() -> this.async.getAllIndexes(options)));
    }

    public Mono<Void> dropPrimaryIndex() {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropPrimaryIndex());
    }

    public Mono<Void> dropPrimaryIndex(DropPrimaryQueryIndexOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropPrimaryIndex(options));
    }

    public Mono<Void> dropIndex(String indexName) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropIndex(indexName));
    }

    public Mono<Void> dropIndex(String indexName, DropQueryIndexOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropIndex(indexName, options));
    }

    public Mono<Void> buildDeferredIndexes() {
        return this.reactor.publishOnUserScheduler(() -> this.async.buildDeferredIndexes());
    }

    public Mono<Void> buildDeferredIndexes(BuildQueryIndexOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.buildDeferredIndexes(options));
    }

    public Mono<Void> watchIndexes(Collection<String> indexNames, Duration timeout) {
        return this.reactor.publishOnUserScheduler(() -> this.async.watchIndexes(indexNames, timeout));
    }

    public Mono<Void> watchIndexes(Collection<String> indexNames, Duration timeout, WatchQueryIndexesOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.watchIndexes(indexNames, timeout, options));
    }
}

