/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.user;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

@Stability.Volatile
@JsonIgnoreProperties(ignoreUnknown=true)
public class Role {
    private final String name;
    private final Optional<String> bucket;
    private final Optional<String> scope;
    private final Optional<String> collection;

    public Role(String roleName) {
        this(roleName, null, null, null);
    }

    public Role(String roleName, String bucket) {
        this(roleName, bucket, null, null);
    }

    @JsonCreator
    public Role(@JsonProperty(value="role") String roleName, @JsonProperty(value="bucket_name") String bucket, @JsonProperty(value="scope_name") String scope, @JsonProperty(value="collection_name") String collection) {
        this.name = Objects.requireNonNull(roleName);
        this.bucket = Optional.ofNullable(bucket);
        this.scope = Role.parseWildcardOptional(scope);
        this.collection = Role.parseWildcardOptional(collection);
        if (this.scope.isPresent() && Role.isNullOrWildcard(bucket)) {
            throw new IllegalArgumentException("When a scope is specified, the bucket cannot be null or wildcard");
        }
        if (this.collection.isPresent() && !this.scope.isPresent()) {
            throw new IllegalArgumentException("When a collection is specified, the scope cannot be null or wildcard.");
        }
    }

    private static boolean isNullOrWildcard(String s) {
        return s == null || "*".equals(s);
    }

    private static Optional<String> parseWildcardOptional(String s) {
        return Role.isNullOrWildcard(s) ? Optional.empty() : Optional.of(s);
    }

    public String name() {
        return this.name;
    }

    public Optional<String> bucket() {
        return this.bucket;
    }

    public Optional<String> scope() {
        return this.scope;
    }

    public Optional<String> collection() {
        return this.collection;
    }

    public String toString() {
        return this.format();
    }

    public String format() {
        return this.name + this.formatTarget();
    }

    private String formatTarget() {
        if (!this.bucket.isPresent()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("[").append(this.bucket.get());
        this.scope.ifPresent(s -> sb.append(":").append((String)s));
        this.collection.ifPresent(s -> sb.append(":").append((String)s));
        return sb.append("]").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role role = (Role)o;
        return this.name.equals(role.name) && this.bucket.equals(role.bucket) && this.scope.equals(role.scope) && this.collection.equals(role.collection);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.bucket, this.scope, this.collection);
    }
}

