/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.collection;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.java.manager.collection.CollectionSpec;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class ScopeSpec {
    private final String name;
    private final Set<CollectionSpec> collectionSpecs;

    private ScopeSpec(String name, Set<CollectionSpec> collectionSpecs) {
        this.name = name;
        this.collectionSpecs = collectionSpecs;
    }

    @Stability.Internal
    public static ScopeSpec create(String name, Set<CollectionSpec> collectionSpecs) {
        return new ScopeSpec(name, collectionSpecs);
    }

    @Stability.Internal
    public static ScopeSpec create(String name) {
        return ScopeSpec.create(name, Collections.emptySet());
    }

    public String name() {
        return this.name;
    }

    public Set<CollectionSpec> collections() {
        return this.collectionSpecs;
    }

    public String toString() {
        return "ScopeSpec{name='" + RedactableArgument.redactMeta((Object)this.name) + '\'' + ", collectionSpecs=" + this.collectionSpecs + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScopeSpec scopeSpec = (ScopeSpec)o;
        return Objects.equals(this.name, scopeSpec.name) && Objects.equals(this.collectionSpecs, scopeSpec.collectionSpecs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.collectionSpecs);
    }
}

