/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transactions.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.transaction.config.CoreTransactionOptions;
import com.couchbase.client.core.transaction.support.TransactionAttemptContextFactory;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.Collection;
import java.time.Duration;
import java.util.Optional;

public class TransactionOptions {
    private Optional<DurabilityLevel> durabilityLevel = Optional.empty();
    private Optional<RequestSpan> parentSpan = Optional.empty();
    private Optional<Duration> timeout = Optional.empty();
    private Optional<TransactionAttemptContextFactory> attemptContextFactory = Optional.empty();
    private Optional<CollectionIdentifier> metadataCollection = Optional.empty();

    public static TransactionOptions transactionOptions() {
        return new TransactionOptions();
    }

    @Stability.Internal
    public CoreTransactionOptions build() {
        return new CoreTransactionOptions(this.durabilityLevel, Optional.empty(), this.parentSpan, this.timeout, this.metadataCollection, this.attemptContextFactory);
    }

    private TransactionOptions() {
    }

    public TransactionOptions durabilityLevel(DurabilityLevel durabilityLevel) {
        Validators.notNull((Object)durabilityLevel, (String)"durabilityLevel");
        this.durabilityLevel = Optional.of(durabilityLevel);
        return this;
    }

    public TransactionOptions parentSpan(RequestSpan parentSpan) {
        Validators.notNull((Object)parentSpan, (String)"parentSpan");
        this.parentSpan = Optional.of(parentSpan);
        return this;
    }

    public TransactionOptions timeout(Duration timeout) {
        Validators.notNull((Object)timeout, (String)"timeout");
        this.timeout = Optional.of(timeout);
        return this;
    }

    public TransactionOptions metadataCollection(Collection collection) {
        Validators.notNull((Object)collection, (String)"metadataCollection");
        CollectionIdentifier coll = new CollectionIdentifier(collection.bucketName(), Optional.of(collection.scopeName()), Optional.of(collection.name()));
        this.metadataCollection = Optional.of(coll);
        return this;
    }

    @Stability.Internal
    TransactionOptions testFactory(TransactionAttemptContextFactory attemptContextFactory) {
        this.attemptContextFactory = Optional.of(attemptContextFactory);
        return this;
    }
}

