/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transactions.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.transaction.config.CoreTransactionsCleanupConfig;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.transactions.TransactionKeyspace;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class TransactionsCleanupConfig {
    private static final Duration CLEANUP_WINDOW_SECS = Duration.of(60L, ChronoUnit.SECONDS);

    public static Builder builder() {
        return new Builder();
    }

    public static Builder cleanupClientAttempts(boolean cleanupClientAttempts) {
        return TransactionsCleanupConfig.builder().cleanupClientAttempts(cleanupClientAttempts);
    }

    public static Builder cleanupLostAttempts(boolean cleanupLostAttempts) {
        return TransactionsCleanupConfig.builder().cleanupLostAttempts(cleanupLostAttempts);
    }

    public static Builder cleanupWindow(Duration cleanupWindow) {
        return TransactionsCleanupConfig.builder().cleanupWindow(cleanupWindow);
    }

    public static Builder addCollection(TransactionKeyspace collection) {
        return TransactionsCleanupConfig.builder().addCollection(collection);
    }

    public Builder addCollections(Collection<TransactionKeyspace> collections) {
        return TransactionsCleanupConfig.builder().addCollections(collections);
    }

    public static class Builder {
        private Optional<Boolean> cleanupLostAttempts = Optional.empty();
        private Optional<Boolean> cleanupClientAttempts = Optional.empty();
        private Optional<Duration> cleanupWindow = Optional.empty();
        private Set<CollectionIdentifier> cleanupSet = new HashSet<CollectionIdentifier>();

        @Stability.Internal
        public CoreTransactionsCleanupConfig build() {
            return new CoreTransactionsCleanupConfig(this.cleanupLostAttempts.orElse(Boolean.parseBoolean(System.getProperty("com.couchbase.transactions.cleanup.lost.enabled", "true"))).booleanValue(), this.cleanupClientAttempts.orElse(Boolean.parseBoolean(System.getProperty("com.couchbase.transactions.cleanup.regular.enabled", "true"))).booleanValue(), this.cleanupWindow.orElse(CLEANUP_WINDOW_SECS), this.cleanupSet);
        }

        public Builder cleanupClientAttempts(boolean cleanupClientAttempts) {
            this.cleanupClientAttempts = Optional.of(cleanupClientAttempts);
            return this;
        }

        public Builder cleanupLostAttempts(boolean cleanupLostAttempts) {
            this.cleanupLostAttempts = Optional.of(cleanupLostAttempts);
            return this;
        }

        public Builder cleanupWindow(Duration cleanupWindow) {
            Validators.notNull((Object)cleanupWindow, (String)"cleanupWindow");
            if (cleanupWindow.isZero()) {
                throw new IllegalArgumentException("cleanupWindow must be > 0");
            }
            this.cleanupWindow = Optional.of(cleanupWindow);
            return this;
        }

        public Builder addCollection(TransactionKeyspace collection) {
            Validators.notNull((Object)collection, (String)"collection");
            this.cleanupSet.add(new CollectionIdentifier(collection.bucket(), Optional.ofNullable(collection.scope()), Optional.ofNullable(collection.collection())));
            return this;
        }

        public Builder addCollections(Collection<TransactionKeyspace> collections) {
            Validators.notNull(collections, (String)"collections");
            collections.forEach(this::addCollection);
            return this;
        }
    }
}

