/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.java.kv.CommonDurabilityOptions;
import com.couchbase.client.java.kv.Expiry;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;

public class DecrementOptions
extends CommonDurabilityOptions<DecrementOptions> {
    private long delta = 1L;
    private Optional<Long> initial = Optional.empty();
    private Expiry expiry = Expiry.none();

    public static DecrementOptions decrementOptions() {
        return new DecrementOptions();
    }

    private DecrementOptions() {
    }

    public DecrementOptions delta(long delta) {
        if (delta < 0L) {
            throw InvalidArgumentException.fromMessage((String)"The delta cannot be less than 0");
        }
        this.delta = delta;
        return this;
    }

    public DecrementOptions initial(long initial) {
        this.initial = Optional.of(initial);
        return this;
    }

    public DecrementOptions expiry(Duration expiry) {
        this.expiry = Expiry.relative(expiry);
        return this;
    }

    public DecrementOptions expiry(Instant expiry) {
        this.expiry = Expiry.absolute(expiry);
        return this;
    }

    @Stability.Internal
    public Built build() {
        return new Built();
    }

    public class Built
    extends CommonDurabilityOptions.BuiltCommonDurabilityOptions {
        Built() {
        }

        public Expiry expiry() {
            return DecrementOptions.this.expiry;
        }

        public Optional<Long> initial() {
            return DecrementOptions.this.initial;
        }

        public long delta() {
            return DecrementOptions.this.delta;
        }
    }
}

