/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.result;

import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SearchNumericRange {
    private final String name;
    private final double min;
    private final double max;
    private final long count;

    @JsonCreator
    public SearchNumericRange(@JsonProperty(value="name") String name, @JsonProperty(value="min") double min, @JsonProperty(value="max") double max, @JsonProperty(value="count") long count) {
        this.name = name;
        this.min = min;
        this.max = max;
        this.count = count;
    }

    public String name() {
        return this.name;
    }

    public Double min() {
        return this.min;
    }

    public Double max() {
        return this.max;
    }

    public long count() {
        return this.count;
    }

    public String toString() {
        return "SearchNumericRange{name='" + this.name + '\'' + ", min=" + this.min + ", max=" + this.max + ", count=" + this.count + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchNumericRange that = (SearchNumericRange)o;
        return Double.compare(that.min, this.min) == 0 && Double.compare(that.max, this.max) == 0 && this.count == that.count && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.min, this.max, this.count);
    }
}

