/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.queries;

import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.search.SearchQuery;
import java.time.Instant;

public class DateRangeQuery
extends SearchQuery {
    private String start;
    private String end;
    private Boolean inclusiveStart = null;
    private Boolean inclusiveEnd = null;
    private String dateTimeParser;
    private String field;

    public DateRangeQuery start(String start, boolean inclusive) {
        this.start = start;
        this.inclusiveStart = inclusive;
        return this;
    }

    public DateRangeQuery start(String start) {
        this.start = start;
        this.inclusiveStart = null;
        return this;
    }

    public DateRangeQuery end(String end, boolean inclusive) {
        this.end = end;
        this.inclusiveEnd = inclusive;
        return this;
    }

    public DateRangeQuery end(String end) {
        this.end = end;
        this.inclusiveEnd = null;
        return this;
    }

    public DateRangeQuery start(Instant start, boolean inclusive) {
        this.start = start.toString();
        this.inclusiveStart = inclusive;
        return this;
    }

    public DateRangeQuery start(Instant start) {
        this.start = start.toString();
        this.inclusiveStart = null;
        return this;
    }

    public DateRangeQuery end(Instant end, boolean inclusive) {
        this.end = end.toString();
        this.inclusiveEnd = inclusive;
        return this;
    }

    public DateRangeQuery end(Instant end) {
        this.end = end.toString();
        this.inclusiveEnd = null;
        return this;
    }

    public DateRangeQuery dateTimeParser(String dateTimeParser) {
        this.dateTimeParser = dateTimeParser;
        return this;
    }

    public DateRangeQuery field(String field) {
        this.field = field;
        return this;
    }

    @Override
    public DateRangeQuery boost(double boost) {
        super.boost(boost);
        return this;
    }

    @Override
    protected void injectParams(JsonObject input) {
        if (this.start == null && this.end == null) {
            throw new NullPointerException("DateRangeQuery needs at least one of start or end");
        }
        if (this.start != null) {
            input.put("start", this.start);
            if (this.inclusiveStart != null) {
                input.put("inclusive_start", this.inclusiveStart);
            }
        }
        if (this.end != null) {
            input.put("end", this.end);
            if (this.inclusiveEnd != null) {
                input.put("inclusive_end", this.inclusiveEnd);
            }
        }
        if (this.dateTimeParser != null) {
            input.put("datetime_parser", this.dateTimeParser);
        }
        if (this.field != null) {
            input.put("field", this.field);
        }
    }
}

