/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.PasswordAuthenticator;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.env.ClusterEnvironment;

public class ClusterOptions {
    private ClusterEnvironment environment;
    private final Authenticator authenticator;

    private ClusterOptions(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public static ClusterOptions clusterOptions(Authenticator authenticator) {
        Validators.notNull((Object)authenticator, (String)"Authenticator");
        return new ClusterOptions(authenticator);
    }

    public static ClusterOptions clusterOptions(String username, String password) {
        Validators.notNullOrEmpty((String)username, (String)"Username");
        Validators.notNullOrEmpty((String)password, (String)"Password");
        return ClusterOptions.clusterOptions((Authenticator)PasswordAuthenticator.create((String)username, (String)password));
    }

    public ClusterOptions environment(ClusterEnvironment environment) {
        Validators.notNull((Object)((Object)environment), (String)"ClusterEnvironment");
        this.environment = environment;
        return this;
    }

    @Stability.Internal
    public Built build() {
        return new Built();
    }

    public class Built {
        Built() {
        }

        public Authenticator authenticator() {
            return ClusterOptions.this.authenticator;
        }

        public ClusterEnvironment environment() {
            return ClusterOptions.this.environment;
        }
    }
}

