/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.core.msg.view.ViewChunkHeader;
import com.couchbase.client.core.msg.view.ViewChunkRow;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.view.ViewMetaData;
import com.couchbase.client.java.view.ViewRow;
import java.util.ArrayList;
import java.util.List;

public class ViewResult {
    private final List<ViewChunkRow> rows;
    private final ViewChunkHeader header;
    private final JsonSerializer serializer;

    ViewResult(ViewChunkHeader header, List<ViewChunkRow> rows, JsonSerializer serializer) {
        this.rows = rows;
        this.header = header;
        this.serializer = serializer;
    }

    public List<ViewRow> rows() {
        ArrayList<ViewRow> converted = new ArrayList<ViewRow>(this.rows.size());
        for (ViewChunkRow row : this.rows) {
            converted.add(new ViewRow(row.data(), this.serializer));
        }
        return converted;
    }

    public ViewMetaData metaData() {
        return ViewMetaData.from(this.header);
    }

    public String toString() {
        return "ViewResult{rows=" + this.rows + ", header=" + this.header + '}';
    }
}

