/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.context.ReducedAnalyticsErrorContext;
import com.couchbase.client.core.error.context.ReducedQueryErrorContext;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncScope;
import com.couchbase.client.java.ReactiveCluster;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.analytics.AnalyticsAccessor;
import com.couchbase.client.java.analytics.AnalyticsOptions;
import com.couchbase.client.java.analytics.ReactiveAnalyticsResult;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.query.QueryAccessor;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.ReactiveQueryResult;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import reactor.core.publisher.Mono;

public class ReactiveScope {
    private final AsyncScope asyncScope;
    private final Map<String, ReactiveCollection> collectionCache = new ConcurrentHashMap<String, ReactiveCollection>();

    ReactiveScope(AsyncScope asyncScope) {
        this.asyncScope = asyncScope;
    }

    public String name() {
        return this.asyncScope.name();
    }

    public String bucketName() {
        return this.asyncScope.bucketName();
    }

    public AsyncScope async() {
        return this.asyncScope;
    }

    @Stability.Volatile
    public Core core() {
        return this.asyncScope.core();
    }

    public ClusterEnvironment environment() {
        return this.asyncScope.environment();
    }

    ReactiveCollection defaultCollection() {
        return this.collectionCache.computeIfAbsent("_default", n -> new ReactiveCollection(this.asyncScope.defaultCollection()));
    }

    @Stability.Volatile
    public ReactiveCollection collection(String collectionName) {
        return this.collectionCache.computeIfAbsent(collectionName, n -> new ReactiveCollection(this.asyncScope.collection((String)n)));
    }

    @Stability.Volatile
    public Mono<ReactiveQueryResult> query(String statement) {
        return this.query(statement, ReactiveCluster.DEFAULT_QUERY_OPTIONS);
    }

    @Stability.Volatile
    public Mono<ReactiveQueryResult> query(String statement, QueryOptions options) {
        Validators.notNull((Object)options, (String)"QueryOptions", () -> new ReducedQueryErrorContext(statement));
        QueryOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment().jsonSerializer() : opts.serializer();
        return Mono.defer(() -> {
            QueryAccessor queryAccessor = this.async().queryAccessor();
            this.async();
            return queryAccessor.queryReactive(AsyncScope.queryRequest(this.bucketName(), this.name(), statement, opts, this.core(), this.environment()), opts, serializer);
        });
    }

    @Stability.Volatile
    public Mono<ReactiveAnalyticsResult> analyticsQuery(String statement) {
        return this.analyticsQuery(statement, ReactiveCluster.DEFAULT_ANALYTICS_OPTIONS);
    }

    @Stability.Volatile
    public Mono<ReactiveAnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        Validators.notNull((Object)options, (String)"AnalyticsOptions", () -> new ReducedAnalyticsErrorContext(statement));
        AnalyticsOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment().jsonSerializer() : opts.serializer();
        return Mono.defer(() -> AnalyticsAccessor.analyticsQueryReactive(this.asyncScope.core(), this.asyncScope.analyticsRequest(statement, opts), serializer));
    }
}

