/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transcoder;

import com.couchbase.client.core.lang.Tuple;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.MutationToken;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.java.document.JsonLongDocument;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.transcoder.AbstractTranscoder;
import com.couchbase.client.java.transcoder.TranscoderUtils;

public class JsonLongTranscoder
extends AbstractTranscoder<JsonLongDocument, Long> {
    @Override
    protected JsonLongDocument doDecode(String id, ByteBuf content, long cas, int expiry, int flags, ResponseStatus status) throws Exception {
        long decoded;
        if (TranscoderUtils.hasCommonFlags(flags) && flags == TranscoderUtils.JSON_COMMON_FLAGS) {
            String val = content.toString(CharsetUtil.UTF_8);
            decoded = Long.valueOf(val);
        } else if (flags == 768 || flags == 512) {
            long rv = 0L;
            int readable = content.readableBytes();
            for (int i = 0; i < readable; ++i) {
                int b = content.readByte();
                rv = rv << 8 | (long)(b < 0 ? 256 + b : b);
            }
            decoded = rv;
        } else if (flags == 0) {
            String val = content.toString(CharsetUtil.UTF_8);
            decoded = Long.valueOf(val);
        } else {
            throw new TranscodingException("Flags (0x" + Integer.toHexString(flags) + ") indicate non JsonLongDocument id " + id + ", could not decode.");
        }
        return this.newDocument(id, expiry, decoded, cas);
    }

    @Override
    protected Tuple2<ByteBuf, Integer> doEncode(JsonLongDocument document) throws Exception {
        return Tuple.create((Object)TranscoderUtils.encodeStringAsUtf8(String.valueOf(document.content())), (Object)TranscoderUtils.LONG_COMPAT_FLAGS);
    }

    @Override
    public JsonLongDocument newDocument(String id, int expiry, Long content, long cas) {
        return JsonLongDocument.create(id, expiry, content, cas);
    }

    @Override
    public JsonLongDocument newDocument(String id, int expiry, Long content, long cas, MutationToken mutationToken) {
        return JsonLongDocument.create(id, expiry, content, cas, mutationToken);
    }

    @Override
    public Class<JsonLongDocument> documentType() {
        return JsonLongDocument.class;
    }
}

