/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transcoder.crypto;

import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.lang.Tuple;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.MutationToken;
import com.couchbase.client.core.utils.Base64;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.encryption.CryptoManager;
import com.couchbase.client.encryption.CryptoProvider;
import com.couchbase.client.encryption.errors.CryptoProviderEncryptFailedException;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.transcoder.AbstractTranscoder;
import com.couchbase.client.java.transcoder.JacksonTransformers;
import com.couchbase.client.java.transcoder.TranscoderUtils;
import java.util.Map;

@InterfaceStability.Committed
public class JsonCryptoTranscoder
extends AbstractTranscoder<JsonDocument, JsonObject> {
    private final CryptoManager cryptoManager;

    public JsonCryptoTranscoder(CryptoManager cryptoManager) {
        this.cryptoManager = cryptoManager;
    }

    private void addEncryption(JsonObject content) throws Exception {
        try {
            if (content != null && content.encryptionPathInfo() != null) {
                for (Map.Entry<String, String> entry : content.encryptionPathInfo().entrySet()) {
                    String encryptedValString;
                    String providerName = entry.getValue();
                    String[] pathSplit = entry.getKey().split("/");
                    int i = 0;
                    for (String path : pathSplit) {
                        pathSplit[i] = path.replace("~1", "/").replace("~0", "~");
                        ++i;
                    }
                    JsonObject parent = content;
                    String lastPointer = pathSplit[pathSplit.length - 1];
                    for (i = 0; i < pathSplit.length - 1; ++i) {
                        parent = (JsonObject)parent.get(pathSplit[i]);
                    }
                    Object value = parent.get(lastPointer);
                    JsonObject encryptedVal = JsonObject.create();
                    CryptoProvider provider = this.cryptoManager.getProvider(providerName);
                    String jsonValue = JacksonTransformers.MAPPER.writeValueAsString(value);
                    encryptedVal.put("kid", provider.getKeyStoreProvider().publicKeyName());
                    encryptedVal.put("alg", provider.getProviderName());
                    int ivSize = provider.getIVSize();
                    if (ivSize > 0) {
                        byte[] encryptedwithIv = provider.encrypt(jsonValue.getBytes());
                        byte[] iv = new byte[ivSize];
                        byte[] encryptedBytes = new byte[encryptedwithIv.length - ivSize];
                        System.arraycopy(encryptedwithIv, 0, iv, 0, ivSize);
                        System.arraycopy(encryptedwithIv, ivSize, encryptedBytes, 0, encryptedBytes.length);
                        encryptedVal.put("iv", Base64.encode((byte[])iv));
                        encryptedVal.put("ciphertext", Base64.encode((byte[])encryptedBytes));
                        encryptedValString = encryptedVal.getString("kid") + encryptedVal.getString("alg") + encryptedVal.getString("iv") + encryptedVal.getString("ciphertext");
                    } else {
                        encryptedVal.put("ciphertext", Base64.encode((byte[])provider.encrypt(jsonValue.getBytes())));
                        encryptedValString = encryptedVal.getString("kid") + encryptedVal.getString("alg") + encryptedVal.getString("ciphertext");
                    }
                    byte[] signature = provider.getSignature(encryptedValString.getBytes());
                    if (signature != null) {
                        encryptedVal.put("sig", Base64.encode((byte[])provider.getSignature(encryptedValString.getBytes())));
                    }
                    parent.removeKey(lastPointer);
                    parent.put("__crypt_" + lastPointer, encryptedVal);
                }
                content.clearEncryptionPaths();
            }
        }
        catch (Exception ex) {
            throw new CryptoProviderEncryptFailedException("Encryption of the fields in the document failed" + ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public Class<JsonDocument> documentType() {
        return JsonDocument.class;
    }

    @Override
    protected Tuple2<ByteBuf, Integer> doEncode(JsonDocument document) throws Exception {
        this.addEncryption((JsonObject)document.content());
        return Tuple.create((Object)this.jsonObjectToByteBuf((JsonObject)document.content()), (Object)TranscoderUtils.JSON_COMPAT_FLAGS);
    }

    @Override
    protected JsonDocument doDecode(String id, ByteBuf content, long cas, int expiry, int flags, ResponseStatus status) throws Exception {
        if (!TranscoderUtils.hasJsonFlags(flags)) {
            throw new TranscodingException("Flags (0x" + Integer.toHexString(flags) + ") indicate non-JSON document for id " + id + ", could not decode.");
        }
        JsonDocument document = this.newDocument(id, expiry, this.byteBufToJsonObject(content), cas);
        if (document.content() != null) {
            ((JsonObject)document.content()).setCryptoManager(this.cryptoManager);
        }
        return document;
    }

    @Override
    public JsonDocument newDocument(String id, int expiry, JsonObject content, long cas) {
        JsonDocument document = JsonDocument.create(id, expiry, content, cas);
        return document;
    }

    @Override
    public JsonDocument newDocument(String id, int expiry, JsonObject content, long cas, MutationToken mutationToken) {
        return JsonDocument.create(id, expiry, content, cas, mutationToken);
    }

    public String jsonObjectToString(JsonObject input) throws Exception {
        return JacksonTransformers.MAPPER.writeValueAsString((Object)input);
    }

    private ByteBuf jsonObjectToByteBuf(JsonObject input) throws Exception {
        return Unpooled.wrappedBuffer((byte[])JacksonTransformers.MAPPER.writeValueAsBytes((Object)input));
    }

    public JsonObject stringToJsonObject(String input) throws Exception {
        return (JsonObject)JacksonTransformers.MAPPER.readValue(input, JsonObject.class);
    }

    public JsonObject byteBufToJsonObject(ByteBuf input) throws Exception {
        return TranscoderUtils.byteBufToClass(input, JsonObject.class, JacksonTransformers.MAPPER);
    }

    public Object byteBufJsonValueToObject(ByteBuf input) throws Exception {
        return TranscoderUtils.byteBufToGenericObject(input, JacksonTransformers.MAPPER);
    }
}

