/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.datastructures;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.subdoc.multi.Mutation;
import com.couchbase.client.java.document.JsonArrayDocument;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.subdoc.DocumentFragment;
import com.couchbase.client.java.subdoc.SubdocOperationResult;
import java.util.Collections;
import rx.functions.Func1;

public class ResultMappingUtils {
    public static Func1<DocumentFragment<Mutation>, Boolean> getMapResultFnForSubdocMutationToBoolean() {
        return new Func1<DocumentFragment<Mutation>, Boolean>(){

            public Boolean call(DocumentFragment<Mutation> documentFragment) {
                ResponseStatus status = documentFragment.status(0);
                if (status == ResponseStatus.SUCCESS) {
                    return true;
                }
                throw new CouchbaseException(status.toString());
            }
        };
    }

    public static Func1<JsonDocument, DocumentFragment<Mutation>> getMapFullDocResultToSubDocFn(final Mutation mutation) {
        return new Func1<JsonDocument, DocumentFragment<Mutation>>(){

            public DocumentFragment<Mutation> call(JsonDocument document) {
                return new DocumentFragment<Mutation>(document.id(), document.cas(), document.mutationToken(), Collections.singletonList(SubdocOperationResult.createResult(null, mutation, ResponseStatus.SUCCESS, null)));
            }
        };
    }

    public static Func1<JsonArrayDocument, DocumentFragment<Mutation>> getMapFullArrayDocResultToSubDocFn(final Mutation mutation) {
        return new Func1<JsonArrayDocument, DocumentFragment<Mutation>>(){

            public DocumentFragment<Mutation> call(JsonArrayDocument document) {
                return new DocumentFragment<Mutation>(document.id(), document.cas(), document.mutationToken(), Collections.singletonList(SubdocOperationResult.createResult(null, mutation, ResponseStatus.SUCCESS, null)));
            }
        };
    }

    public static <E> DocumentFragment<Mutation> convertToSubDocumentResult(ResponseStatus status, Mutation mutation, E element) {
        return new DocumentFragment<Mutation>(null, 0L, null, Collections.singletonList(SubdocOperationResult.createResult(null, mutation, status, element)));
    }
}

