/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.analytics;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.analytics.AnalyticsDeferredResultHandle;
import com.couchbase.client.java.analytics.AnalyticsQueryRow;
import com.couchbase.client.java.analytics.AsyncAnalyticsDeferredResultHandle;
import com.couchbase.client.java.analytics.AsyncAnalyticsQueryRow;
import com.couchbase.client.java.analytics.DefaultAnalyticsQueryRow;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class DefaultAnalyticsDeferredResultHandle
implements AnalyticsDeferredResultHandle {
    private final AsyncAnalyticsDeferredResultHandle asyncHandle;

    public DefaultAnalyticsDeferredResultHandle(AsyncAnalyticsDeferredResultHandle asyncHandle) {
        Objects.requireNonNull(asyncHandle, "The asynchronous deferred handle is required");
        this.asyncHandle = asyncHandle;
    }

    @Override
    public String getStatusHandleUri() {
        return this.asyncHandle.getStatusHandleUri();
    }

    @Override
    public String getResultHandleUri() {
        return this.asyncHandle.getResultHandleUri();
    }

    @Override
    public List<AnalyticsQueryRow> allRows() {
        List rows = (List)this.asyncHandle.rows().toList().toBlocking().single();
        ArrayList<AnalyticsQueryRow> res = new ArrayList<AnalyticsQueryRow>(rows.size());
        for (AsyncAnalyticsQueryRow row : rows) {
            res.add(new DefaultAnalyticsQueryRow(row));
        }
        return res;
    }

    @Override
    public Iterator<AnalyticsQueryRow> rows() {
        return this.allRows().iterator();
    }

    @Override
    public String status() {
        return (String)this.asyncHandle.status().toBlocking().single();
    }

    public String toString() {
        return "DefaultAnalyticsDeferredResultHandle{statusUri='" + this.getStatusHandleUri() + '\'' + ", resultUri='" + this.getResultHandleUri() + '\'' + '}';
    }
}

