/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.dcp.transport.netty.ConnectInterceptingHandler;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.handler.codec.base64.Base64;
import com.couchbase.client.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpRequest;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpResponse;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;

class StartStreamHandler
extends ConnectInterceptingHandler<HttpResponse> {
    private final String bucket;
    private final String username;
    private final String password;

    StartStreamHandler(String bucket, String username, String password) {
        this.bucket = bucket;
        this.username = username;
        this.password = password;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        String terseUri = "/pools/default/bs/" + this.bucket;
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, terseUri);
        request.headers().add("Accept", (Object)"application/json");
        this.addHttpBasicAuth(ctx, (HttpRequest)request);
        ctx.writeAndFlush((Object)request);
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpResponse msg) throws Exception {
        int statusCode = msg.getStatus().code();
        if (statusCode == 200) {
            ctx.pipeline().remove((ChannelHandler)this);
            this.originalPromise().setSuccess();
            ctx.fireChannelActive();
        } else {
            CouchbaseException exception;
            switch (statusCode) {
                case 401: {
                    exception = new CouchbaseException("Unauthorized (bucket/password invalid) - please check credentials!");
                    break;
                }
                default: {
                    exception = new CouchbaseException("Unknown error code during connect: " + msg.getStatus());
                }
            }
            this.originalPromise().setFailure((Throwable)exception);
        }
    }

    private void addHttpBasicAuth(ChannelHandlerContext ctx, HttpRequest request) {
        String pw = this.password == null ? "" : this.password;
        ByteBuf raw = ctx.alloc().buffer(this.username.length() + pw.length() + 1);
        raw.writeBytes((this.username + ":" + pw).getBytes(CharsetUtil.UTF_8));
        ByteBuf encoded = Base64.encode((ByteBuf)raw, (boolean)false);
        request.headers().add("Authorization", (Object)("Basic " + encoded.toString(CharsetUtil.UTF_8)));
        encoded.release();
        raw.release();
    }
}

