/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.dcp.conductor.DcpChannelControlHandler;
import com.couchbase.client.dcp.config.ClientEnvironment;
import com.couchbase.client.dcp.config.DcpControl;
import com.couchbase.client.dcp.config.SSLEngineFactory;
import com.couchbase.client.dcp.transport.netty.AuthHandler;
import com.couchbase.client.dcp.transport.netty.DcpConnectHandler;
import com.couchbase.client.dcp.transport.netty.DcpControlHandler;
import com.couchbase.client.dcp.transport.netty.DcpMessageHandler;
import com.couchbase.client.deps.io.netty.channel.Channel;
import com.couchbase.client.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.deps.io.netty.channel.ChannelInitializer;
import com.couchbase.client.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.deps.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import com.couchbase.client.deps.io.netty.handler.logging.LogLevel;
import com.couchbase.client.deps.io.netty.handler.logging.LoggingHandler;
import com.couchbase.client.deps.io.netty.handler.ssl.SslHandler;
import com.couchbase.client.deps.io.netty.handler.timeout.IdleStateHandler;

public class DcpPipeline
extends ChannelInitializer<Channel> {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(DcpPipeline.class);
    private final ClientEnvironment environment;
    private final DcpChannelControlHandler controlHandler;
    private final SSLEngineFactory sslEngineFactory;

    public DcpPipeline(ClientEnvironment environment, DcpChannelControlHandler controlHandler) {
        this.environment = environment;
        this.controlHandler = controlHandler;
        this.sslEngineFactory = environment.sslEnabled() ? new SSLEngineFactory(environment) : null;
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.environment.sslEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new SslHandler(this.sslEngineFactory.get())});
        }
        pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 8, 4, 12, 0, false)});
        if (LOGGER.isTraceEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.TRACE)});
        }
        DcpControl control = this.environment.dcpControl();
        pipeline.addLast(new ChannelHandler[]{new AuthHandler(this.environment.username(), this.environment.password())}).addLast(new ChannelHandler[]{new DcpConnectHandler(this.environment.connectionNameGenerator(), this.environment.bucket())}).addLast(new ChannelHandler[]{new DcpControlHandler(control)});
        if (control.noopEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(2 * control.noopIntervalSeconds(), 0, 0)});
        }
        pipeline.addLast(new ChannelHandler[]{new DcpMessageHandler(ch, this.environment, this.controlHandler)});
    }
}

