/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.state;

import com.couchbase.client.dcp.state.FailoverLogEntry;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonIgnore;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class PartitionState {
    @JsonProperty(value="flog")
    private final List<FailoverLogEntry> failoverLog = new CopyOnWriteArrayList<FailoverLogEntry>();
    @JsonProperty(value="ss")
    private volatile long startSeqno = 0L;
    @JsonProperty(value="es")
    private volatile long endSeqno = 0L;
    @JsonProperty(value="sss")
    private volatile long snapshotStartSeqno = 0L;
    @JsonProperty(value="ses")
    private volatile long snapshotEndSeqno = 0L;

    public long getEndSeqno() {
        return this.endSeqno;
    }

    public long getStartSeqno() {
        return this.startSeqno;
    }

    public void setStartSeqno(long startSeqno) {
        this.startSeqno = startSeqno;
    }

    public void setEndSeqno(long endSeqno) {
        this.endSeqno = endSeqno;
    }

    public List<FailoverLogEntry> getFailoverLog() {
        return this.failoverLog;
    }

    public void addToFailoverLog(long seqno, long vbuuid) {
        this.failoverLog.add(new FailoverLogEntry(seqno, vbuuid));
    }

    public long getSnapshotStartSeqno() {
        return this.snapshotStartSeqno;
    }

    public void setSnapshotStartSeqno(long snapshotStartSeqno) {
        this.snapshotStartSeqno = snapshotStartSeqno;
    }

    public long getSnapshotEndSeqno() {
        return this.snapshotEndSeqno;
    }

    public void setSnapshotEndSeqno(long snapshotEndSeqno) {
        this.snapshotEndSeqno = snapshotEndSeqno;
    }

    @JsonIgnore
    public boolean isAtEnd() {
        return this.startSeqno == this.endSeqno;
    }

    @JsonIgnore
    public long getLastUuid() {
        return this.failoverLog.isEmpty() ? 0L : this.failoverLog.get(0).getUuid();
    }

    public String toString() {
        return "{log=" + this.failoverLog + ", ss=" + this.startSeqno + ", es=" + this.endSeqno + ", sss=" + this.snapshotStartSeqno + ", ses=" + this.snapshotEndSeqno + '}';
    }
}

