/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.config;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DcpControl
implements Iterable<Map.Entry<String, String>> {
    private static final int DEFAULT_NOOP_INTERVAL_SECONDS = 120;
    private Map<String, String> values = new HashMap<String, String>();

    public DcpControl put(Names name, String value) {
        if (name == Names.ENABLE_NOOP && this.get(Names.SET_NOOP_INTERVAL) == null) {
            this.put(Names.SET_NOOP_INTERVAL, Integer.toString(120));
        }
        this.values.put(name.value(), value);
        return this;
    }

    public String get(Names name) {
        return this.values.get(name.value());
    }

    public boolean bufferAckEnabled() {
        String bufSize = this.get(Names.CONNECTION_BUFFER_SIZE);
        return bufSize != null && Integer.parseInt(bufSize) > 0;
    }

    public boolean noopEnabled() {
        return "true".equals(this.get(Names.ENABLE_NOOP));
    }

    public int noopIntervalSeconds() {
        try {
            return DcpControl.parsePositiveInteger(this.get(Names.SET_NOOP_INTERVAL));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Bad value for '" + Names.SET_NOOP_INTERVAL.value() + "'; " + e.getMessage());
        }
    }

    private static int parsePositiveInteger(String s) {
        int value = Integer.parseInt(s);
        if (value < 1) {
            throw new IllegalArgumentException("Value '" + s + "' is not positive.");
        }
        return value;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.values.entrySet().iterator();
    }

    public String toString() {
        return "DcpControl{" + this.values + '}';
    }

    public static enum Names {
        ENABLE_NOOP("enable_noop"),
        CONNECTION_BUFFER_SIZE("connection_buffer_size"),
        SET_NOOP_INTERVAL("set_noop_interval"),
        SET_PRIORITY("set_priority"),
        ENABLE_EXT_METADATA("enable_ext_metadata"),
        ENABLE_VALUE_COMPRESSION("enable_value_compression"),
        SUPPORTS_CURSOR_DROPPING("supports_cursor_dropping");

        private String value;

        private Names(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

