/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.protocol.views;

import com.couchbase.client.CouchbaseClient;
import com.couchbase.client.protocol.views.ComplexKey;
import com.couchbase.client.protocol.views.Query;
import com.couchbase.client.protocol.views.View;
import com.couchbase.client.protocol.views.ViewResponse;
import com.couchbase.client.protocol.views.ViewRow;
import java.util.Iterator;

public class Paginator
implements Iterator<ViewResponse> {
    private final CouchbaseClient client;
    private final View view;
    private final Query query;
    private final int limit;
    private volatile State currentState;
    private ViewResponse nextResponse = null;
    private int currentPage;
    private String nextStartKeyDocID = null;
    private String nextStartKey = null;
    private boolean alreadyCalled;
    private int totalLimit;
    private Class<?> forcedKeyType = null;

    public Paginator(CouchbaseClient client, View view, Query query, int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Number of documents per page must be greater than zero.");
        }
        this.client = client;
        this.view = view;
        this.query = query.copy();
        this.limit = limit;
        this.totalLimit = this.query.getLimit() > 0 ? this.query.getLimit() : -1;
        this.query.setLimit(limit + 1);
        this.currentState = State.INITIALIZED;
        this.currentPage = 1;
        this.alreadyCalled = false;
    }

    @Override
    public final boolean hasNext() {
        if (this.currentState == State.FINISHED) {
            return false;
        }
        if (this.alreadyCalled) {
            return true;
        }
        this.alreadyCalled = true;
        this.fetchNextPage();
        if (this.currentState == State.INITIALIZED) {
            this.currentState = State.PAGING;
        }
        return true;
    }

    private void fetchNextPage() {
        if (this.currentState == State.PAGING) {
            if (this.query.willReduce()) {
                this.query.setSkip(this.limit * (this.currentPage - 1));
            } else {
                this.query.setStartkeyDocID(this.nextStartKeyDocID);
                this.query.setRangeStart(this.convertKey(this.nextStartKey));
            }
        }
        if (this.totalLimit > 0 && this.currentPage * this.limit >= this.totalLimit) {
            int reduceBy = this.currentPage * this.limit - this.totalLimit;
            this.query.setLimit(this.limit - reduceBy);
        }
        this.nextResponse = this.client.query(this.view, this.query);
        if (this.nextResponse.size() == this.limit + 1) {
            ViewRow nextRow = this.nextResponse.removeLastElement();
            if (!this.query.willReduce()) {
                this.nextStartKeyDocID = nextRow.getId();
                this.nextStartKey = nextRow.getKey();
            }
        } else {
            this.currentState = State.FINISHED;
        }
        ++this.currentPage;
    }

    @Override
    public final ViewResponse next() {
        this.alreadyCalled = false;
        if (this.currentState == State.INITIALIZED) {
            return null;
        }
        return this.nextResponse;
    }

    public void forceKeyType(Class<?> clazz) {
        this.forcedKeyType = clazz;
    }

    private String convertKey(String original) {
        if (this.forcedKeyType == null) {
            return original;
        }
        if (this.forcedKeyType.getSimpleName().equals("Integer")) {
            return ComplexKey.of(Integer.parseInt(original)).toJson();
        }
        return ComplexKey.of(original).toJson();
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("Remove is unsupported");
    }

    static enum State {
        INITIALIZED,
        PAGING,
        FINISHED;

    }
}

