/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.message.builder;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.builder.DefaultHeaderDataBuilder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;

public class ObjectMappingHeaderDataBuilder
extends DefaultHeaderDataBuilder {
    private final ObjectMapper mapper;
    private final String mapperName;

    public ObjectMappingHeaderDataBuilder(Object model) {
        super(model);
        this.mapper = null;
        this.mapperName = null;
    }

    public ObjectMappingHeaderDataBuilder(Object model, ObjectMapper mapper) {
        super(model);
        this.mapper = mapper;
        this.mapperName = null;
    }

    public ObjectMappingHeaderDataBuilder(Object model, String mapperName) {
        super(model);
        this.mapperName = mapperName;
        this.mapper = null;
    }

    public String buildHeaderData(TestContext context) {
        if (this.getHeaderData() == null || this.getHeaderData() instanceof String) {
            return super.buildHeaderData(context);
        }
        if (this.mapper != null) {
            return this.buildHeaderData(this.mapper, this.getHeaderData(), context);
        }
        if (this.mapperName != null) {
            if (context.getReferenceResolver().isResolvable(this.mapperName)) {
                ObjectMapper objectMapper = (ObjectMapper)context.getReferenceResolver().resolve(this.mapperName, ObjectMapper.class);
                return this.buildHeaderData(objectMapper, this.getHeaderData(), context);
            }
            throw new CitrusRuntimeException(String.format("Unable to find proper object mapper for name '%s'", this.mapperName));
        }
        Map mappers = context.getReferenceResolver().resolveAll(ObjectMapper.class);
        if (mappers.size() == 1) {
            return this.buildHeaderData((ObjectMapper)mappers.values().iterator().next(), this.getHeaderData(), context);
        }
        throw new CitrusRuntimeException(String.format("Unable to auto detect object mapper - found %d matching mapper instances in reference resolver", mappers.size()));
    }

    private String buildHeaderData(ObjectMapper mapper, Object model, TestContext context) {
        try {
            return context.replaceDynamicContentInString(mapper.writer().writeValueAsString(model));
        }
        catch (JsonProcessingException e) {
            throw new CitrusRuntimeException("Failed to map object graph for message header data", (Throwable)e);
        }
    }
}

