/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.TestAction;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.ReceiveMessageBuilder;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.ws.actions.ReceiveSoapMessageAction;
import com.consol.citrus.ws.message.SoapAttachment;
import com.consol.citrus.ws.message.SoapMessage;
import com.consol.citrus.ws.validation.SoapAttachmentValidator;
import java.io.IOException;
import java.nio.charset.Charset;
import org.springframework.core.io.Resource;

public class SoapServerRequestActionBuilder
extends ReceiveMessageBuilder<ReceiveSoapMessageAction, SoapServerRequestActionBuilder> {
    private SoapMessage soapMessage = new SoapMessage();

    public SoapServerRequestActionBuilder(DelegatingTestAction<TestAction> delegate, Endpoint soapServer) {
        super(delegate);
        delegate.setDelegate((TestAction)new ReceiveSoapMessageAction());
        this.getAction().setEndpoint(soapServer);
        this.message((Message)this.soapMessage);
        this.messageType(MessageType.XML);
        this.headerNameIgnoreCase(true);
    }

    @Override
    protected void setPayload(String payload) {
        this.soapMessage.setPayload((Object)payload);
    }

    public SoapServerRequestActionBuilder soapAction(String soapAction) {
        this.soapMessage.header("citrus_soap_action", (Object)soapAction);
        return this;
    }

    public SoapServerRequestActionBuilder attachment(String contentId, String contentType, String content) {
        SoapAttachment attachment = new SoapAttachment();
        attachment.setContentId(contentId);
        attachment.setContentType(contentType);
        attachment.setContent(content);
        this.getAction().getAttachments().add(attachment);
        return this;
    }

    public SoapServerRequestActionBuilder attachment(String contentId, String contentType, Resource contentResource) {
        return this.attachment(contentId, contentType, contentResource, FileUtils.getDefaultCharset());
    }

    public SoapServerRequestActionBuilder attachment(String contentId, String contentType, Resource contentResource, Charset charset) {
        SoapAttachment attachment = new SoapAttachment();
        attachment.setContentId(contentId);
        attachment.setContentType(contentType);
        try {
            attachment.setContent(FileUtils.readToString((Resource)contentResource, (Charset)charset));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read attachment content resource", (Throwable)e);
        }
        this.getAction().getAttachments().add(attachment);
        return this;
    }

    public SoapServerRequestActionBuilder charset(String charsetName) {
        if (!this.getAction().getAttachments().isEmpty()) {
            ((SoapAttachment)this.getAction().getAttachments().get(this.getAction().getAttachments().size() - 1)).setCharsetName(charsetName);
        }
        return this;
    }

    public SoapServerRequestActionBuilder attachment(SoapAttachment attachment) {
        this.getAction().getAttachments().add(attachment);
        return this;
    }

    public SoapServerRequestActionBuilder attachmentValidator(SoapAttachmentValidator validator) {
        this.getAction().setAttachmentValidator(validator);
        return this;
    }

    public SoapServerRequestActionBuilder contentType(String contentType) {
        this.soapMessage.header("citrus_http_Content-Type", (Object)contentType);
        return this;
    }

    public SoapServerRequestActionBuilder accept(String accept) {
        this.soapMessage.header("citrus_http_Accept", (Object)accept);
        return this;
    }

    protected ReceiveSoapMessageAction getAction() {
        return (ReceiveSoapMessageAction)super.getAction();
    }
}

