/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.TestAction;
import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.ReceiveMessageBuilder;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.http.message.HttpMessageContentBuilder;
import com.consol.citrus.http.message.HttpMessageUtils;
import com.consol.citrus.http.message.HttpQueryParamHeaderValidator;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.validation.HeaderValidator;
import com.consol.citrus.validation.builder.AbstractMessageContentBuilder;
import com.consol.citrus.validation.builder.MessageContentBuilder;
import com.consol.citrus.validation.builder.StaticMessageContentBuilder;
import javax.servlet.http.Cookie;
import org.springframework.http.HttpMethod;

public class HttpServerRequestActionBuilder
extends ReceiveMessageBuilder<ReceiveMessageAction, HttpServerRequestActionBuilder> {
    private HttpMessage httpMessage = new HttpMessage();

    public HttpServerRequestActionBuilder(DelegatingTestAction<TestAction> delegate, Endpoint httpServer) {
        super(delegate);
        delegate.setDelegate((TestAction)new ReceiveMessageAction());
        this.getAction().setEndpoint(httpServer);
        this.initMessage(this.httpMessage);
        this.messageType(MessageType.XML);
        this.headerNameIgnoreCase(true);
        this.headerValidator(new HeaderValidator[]{new HttpQueryParamHeaderValidator()});
    }

    private void initMessage(HttpMessage message) {
        StaticMessageContentBuilder staticMessageContentBuilder = StaticMessageContentBuilder.withMessage((Message)message);
        staticMessageContentBuilder.setMessageHeaders(message.getHeaders());
        this.getAction().setMessageBuilder((MessageContentBuilder)new HttpMessageContentBuilder(message, (AbstractMessageContentBuilder)staticMessageContentBuilder));
    }

    @Override
    protected void setPayload(String payload) {
        this.httpMessage.setPayload((Object)payload);
    }

    @Override
    public HttpServerRequestActionBuilder name(String name) {
        this.httpMessage.setName(name);
        return (HttpServerRequestActionBuilder)super.name(name);
    }

    public HttpServerRequestActionBuilder path(String path) {
        this.httpMessage.path(path);
        return this;
    }

    public HttpServerRequestActionBuilder method(HttpMethod method) {
        this.httpMessage.method(method);
        return this;
    }

    public HttpServerRequestActionBuilder queryParam(String name) {
        this.httpMessage.queryParam(name, null);
        return this;
    }

    public HttpServerRequestActionBuilder queryParam(String name, String value) {
        this.httpMessage.queryParam(name, value);
        return this;
    }

    public HttpServerRequestActionBuilder version(String version) {
        this.httpMessage.version(version);
        return this;
    }

    public HttpServerRequestActionBuilder contentType(String contentType) {
        this.httpMessage.contentType(contentType);
        return this;
    }

    public HttpServerRequestActionBuilder accept(String accept) {
        this.httpMessage.accept(accept);
        return this;
    }

    public HttpServerRequestActionBuilder cookie(Cookie cookie) {
        this.httpMessage.cookie(cookie);
        return this;
    }

    @Override
    public HttpServerRequestActionBuilder message(Message message) {
        HttpMessageUtils.copy((Message)message, (HttpMessage)this.httpMessage);
        return this;
    }
}

