/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.TestAction;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.AbstractTestActionBuilder;
import com.consol.citrus.dsl.builder.HttpClientRequestActionBuilder;
import com.consol.citrus.dsl.builder.HttpClientResponseActionBuilder;
import com.consol.citrus.endpoint.Endpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;

public class HttpClientActionBuilder
extends AbstractTestActionBuilder<DelegatingTestAction<TestAction>> {
    private ApplicationContext applicationContext;
    private Endpoint httpClient;
    private String httpClientUri;

    public HttpClientActionBuilder(DelegatingTestAction<TestAction> action, Endpoint httpClient) {
        super(action);
        this.httpClient = httpClient;
    }

    public HttpClientActionBuilder(DelegatingTestAction<TestAction> action, String httpClientUri) {
        super(action);
        this.httpClientUri = httpClientUri;
    }

    public HttpClientSendActionBuilder send() {
        return new HttpClientSendActionBuilder();
    }

    public HttpClientReceiveActionBuilder receive() {
        return new HttpClientReceiveActionBuilder();
    }

    private HttpClientRequestActionBuilder request(HttpMethod method, String path) {
        HttpClientRequestActionBuilder httpClientRequestActionBuilder = this.httpClient != null ? new HttpClientRequestActionBuilder((DelegatingTestAction<TestAction>)((DelegatingTestAction)this.action), this.httpClient) : new HttpClientRequestActionBuilder((DelegatingTestAction<TestAction>)((DelegatingTestAction)this.action), this.httpClientUri);
        httpClientRequestActionBuilder.withApplicationContext(this.applicationContext);
        httpClientRequestActionBuilder.method(method);
        if (StringUtils.hasText((String)path)) {
            httpClientRequestActionBuilder.path(path);
        }
        return httpClientRequestActionBuilder;
    }

    public HttpClientActionBuilder withApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        return this;
    }

    public class HttpClientReceiveActionBuilder {
        public HttpClientResponseActionBuilder response() {
            HttpClientResponseActionBuilder httpClientResponseActionBuilder = HttpClientActionBuilder.this.httpClient != null ? new HttpClientResponseActionBuilder((DelegatingTestAction<TestAction>)((DelegatingTestAction)HttpClientActionBuilder.this.action), HttpClientActionBuilder.this.httpClient) : new HttpClientResponseActionBuilder((DelegatingTestAction<TestAction>)((DelegatingTestAction)HttpClientActionBuilder.this.action), HttpClientActionBuilder.this.httpClientUri);
            httpClientResponseActionBuilder.withApplicationContext(HttpClientActionBuilder.this.applicationContext);
            return httpClientResponseActionBuilder;
        }

        public HttpClientResponseActionBuilder response(HttpStatus status) {
            HttpClientResponseActionBuilder httpClientResponseActionBuilder = HttpClientActionBuilder.this.httpClient != null ? new HttpClientResponseActionBuilder((DelegatingTestAction<TestAction>)((DelegatingTestAction)HttpClientActionBuilder.this.action), HttpClientActionBuilder.this.httpClient) : new HttpClientResponseActionBuilder((DelegatingTestAction<TestAction>)((DelegatingTestAction)HttpClientActionBuilder.this.action), HttpClientActionBuilder.this.httpClientUri);
            httpClientResponseActionBuilder.withApplicationContext(HttpClientActionBuilder.this.applicationContext);
            httpClientResponseActionBuilder.status(status);
            return httpClientResponseActionBuilder;
        }
    }

    public class HttpClientSendActionBuilder {
        public HttpClientRequestActionBuilder get() {
            return HttpClientActionBuilder.this.request(HttpMethod.GET, null);
        }

        public HttpClientRequestActionBuilder get(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.GET, path);
        }

        public HttpClientRequestActionBuilder post() {
            return HttpClientActionBuilder.this.request(HttpMethod.POST, null);
        }

        public HttpClientRequestActionBuilder post(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.POST, path);
        }

        public HttpClientRequestActionBuilder put() {
            return HttpClientActionBuilder.this.request(HttpMethod.PUT, null);
        }

        public HttpClientRequestActionBuilder put(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.PUT, path);
        }

        public HttpClientRequestActionBuilder delete() {
            return HttpClientActionBuilder.this.request(HttpMethod.DELETE, null);
        }

        public HttpClientRequestActionBuilder delete(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.DELETE, path);
        }

        public HttpClientRequestActionBuilder head() {
            return HttpClientActionBuilder.this.request(HttpMethod.HEAD, null);
        }

        public HttpClientRequestActionBuilder head(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.HEAD, path);
        }

        public HttpClientRequestActionBuilder options() {
            return HttpClientActionBuilder.this.request(HttpMethod.OPTIONS, null);
        }

        public HttpClientRequestActionBuilder options(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.OPTIONS, path);
        }

        public HttpClientRequestActionBuilder trace() {
            return HttpClientActionBuilder.this.request(HttpMethod.TRACE, null);
        }

        public HttpClientRequestActionBuilder trace(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.TRACE, path);
        }

        public HttpClientRequestActionBuilder patch() {
            return HttpClientActionBuilder.this.request(HttpMethod.PATCH, null);
        }

        public HttpClientRequestActionBuilder patch(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.PATCH, path);
        }
    }
}

