/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.dsl.builder.AbstractExceptionContainerBuilder;
import com.consol.citrus.dsl.design.TestDesigner;
import com.consol.citrus.dsl.runner.TestRunner;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.validation.xml.XmlMessageValidationContext;
import com.consol.citrus.ws.actions.AssertSoapFault;
import com.consol.citrus.ws.validation.SoapFaultDetailValidationContext;
import com.consol.citrus.ws.validation.SoapFaultValidator;
import java.io.IOException;
import java.nio.charset.Charset;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

public class AssertSoapFaultBuilder
extends AbstractExceptionContainerBuilder<AssertSoapFault> {
    private XmlMessageValidationContext validationContext = new XmlMessageValidationContext();

    public AssertSoapFaultBuilder(TestDesigner designer, AssertSoapFault action) {
        super(designer, action);
        SoapFaultDetailValidationContext soapFaultDetailValidationContext = new SoapFaultDetailValidationContext();
        soapFaultDetailValidationContext.addValidationContext(this.validationContext);
        action.setValidationContext((ValidationContext)soapFaultDetailValidationContext);
    }

    public AssertSoapFaultBuilder(TestDesigner designer) {
        this(designer, new AssertSoapFault());
    }

    public AssertSoapFaultBuilder(TestRunner runner, AssertSoapFault action) {
        super(runner, action);
        SoapFaultDetailValidationContext soapFaultDetailValidationContext = new SoapFaultDetailValidationContext();
        soapFaultDetailValidationContext.addValidationContext(this.validationContext);
        action.setValidationContext((ValidationContext)soapFaultDetailValidationContext);
    }

    public AssertSoapFaultBuilder(TestRunner runner) {
        this(runner, new AssertSoapFault());
    }

    public AssertSoapFaultBuilder faultCode(String code) {
        ((AssertSoapFault)this.action).setFaultCode(code);
        return this;
    }

    public AssertSoapFaultBuilder faultString(String faultString) {
        ((AssertSoapFault)this.action).setFaultString(faultString);
        return this;
    }

    public AssertSoapFaultBuilder faultActor(String faultActor) {
        ((AssertSoapFault)this.action).setFaultActor(faultActor);
        return this;
    }

    public AssertSoapFaultBuilder faultDetail(String faultDetail) {
        ((AssertSoapFault)this.action).getFaultDetails().add(faultDetail);
        return this;
    }

    public AssertSoapFaultBuilder faultDetailResource(Resource resource) {
        return this.faultDetailResource(resource, FileUtils.getDefaultCharset());
    }

    public AssertSoapFaultBuilder faultDetailResource(Resource resource, Charset charset) {
        try {
            ((AssertSoapFault)this.action).getFaultDetails().add(FileUtils.readToString((Resource)resource, (Charset)charset));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read fault detail resource", (Throwable)e);
        }
        return this;
    }

    public AssertSoapFaultBuilder faultDetailResource(String filePath) {
        ((AssertSoapFault)this.action).getFaultDetailResourcePaths().add(filePath);
        return this;
    }

    public AssertSoapFaultBuilder validator(SoapFaultValidator validator) {
        ((AssertSoapFault)this.action).setValidator(validator);
        return this;
    }

    public AssertSoapFaultBuilder validator(String validatorName, ApplicationContext applicationContext) {
        ((AssertSoapFault)this.action).setValidator((SoapFaultValidator)applicationContext.getBean(validatorName, SoapFaultValidator.class));
        return this;
    }

    public AssertSoapFaultBuilder schemaValidation(boolean enabled) {
        this.validationContext.setSchemaValidation(enabled);
        return this;
    }

    public AssertSoapFaultBuilder xsd(String schemaName) {
        this.validationContext.setSchema(schemaName);
        return this;
    }

    public AssertSoapFaultBuilder xsdSchemaRepository(String schemaRepository) {
        this.validationContext.setSchemaRepository(schemaRepository);
        return this;
    }

    public AssertSoapFaultBuilder withApplicationContext(ApplicationContext applicationContext) {
        if (applicationContext.containsBean("soapFaultValidator")) {
            this.validator((SoapFaultValidator)applicationContext.getBean("soapFaultValidator", SoapFaultValidator.class));
        }
        return this;
    }
}

