/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.message;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.http.client.HttpEndpointConfiguration;
import com.consol.citrus.http.message.CookieConverter;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageConverter;
import com.consol.citrus.message.MessageHeaderUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class HttpMessageConverter
implements MessageConverter<HttpEntity<?>, HttpEntity<?>, HttpEndpointConfiguration> {
    private CookieConverter cookieConverter;

    public HttpMessageConverter() {
        this.cookieConverter = new CookieConverter();
    }

    public HttpMessageConverter(CookieConverter cookieConverter) {
        this.cookieConverter = cookieConverter;
    }

    public HttpEntity<?> convertOutbound(Message message, HttpEndpointConfiguration endpointConfiguration, TestContext context) {
        HttpMessage httpMessage = this.convertOutboundMessage(message);
        HttpHeaders httpHeaders = this.createHttpHeaders(httpMessage, endpointConfiguration);
        Object payload = httpMessage.getPayload();
        if (httpMessage.getStatusCode() != null) {
            return new ResponseEntity(payload, (MultiValueMap)httpHeaders, httpMessage.getStatusCode());
        }
        for (Cookie cookie : httpMessage.getCookies()) {
            httpHeaders.add("Cookie", cookie.getName() + "=" + context.replaceDynamicContentInString(cookie.getValue()));
        }
        HttpMethod method = this.determineHttpMethod(endpointConfiguration, httpMessage);
        return this.createHttpEntity(httpHeaders, payload, method);
    }

    public HttpMessage convertInbound(HttpEntity<?> message, HttpEndpointConfiguration endpointConfiguration, TestContext context) {
        Map mappedHeaders = endpointConfiguration.getHeaderMapper().toHeaders((Object)message.getHeaders());
        HttpMessage httpMessage = new HttpMessage(this.extractMessageBody(message), this.convertHeaderTypes(mappedHeaders));
        for (Map.Entry<String, String> customHeader : this.getCustomHeaders(message.getHeaders(), mappedHeaders).entrySet()) {
            httpMessage.setHeader(customHeader.getKey(), customHeader.getValue());
        }
        if (message instanceof ResponseEntity) {
            httpMessage.status(((ResponseEntity)message).getStatusCode());
            httpMessage.version("HTTP/1.1");
            if (endpointConfiguration.isHandleCookies()) {
                httpMessage.setCookies(this.cookieConverter.convertCookies(message));
            }
        }
        return httpMessage;
    }

    public void convertOutbound(HttpEntity externalMessage, Message internalMessage, HttpEndpointConfiguration endpointConfiguration, TestContext context) {
        throw new UnsupportedOperationException("HttpMessageConverter does not support predefined HttpEntity objects");
    }

    private Map<String, String> getCustomHeaders(HttpHeaders httpHeaders, Map<String, Object> mappedHeaders) {
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        for (Map.Entry header : httpHeaders.entrySet()) {
            if (mappedHeaders.containsKey(header.getKey())) continue;
            customHeaders.put((String)header.getKey(), StringUtils.collectionToCommaDelimitedString((Collection)((Collection)header.getValue())));
        }
        return customHeaders;
    }

    private Map<String, Object> convertHeaderTypes(Map<String, Object> headers) {
        HashMap<String, Object> convertedHeaders = new HashMap<String, Object>();
        for (Map.Entry<String, Object> header : headers.entrySet()) {
            if (header.getValue() instanceof Collection) {
                Collection value = (Collection)header.getValue();
                convertedHeaders.put(header.getKey(), StringUtils.collectionToCommaDelimitedString((Collection)value));
                continue;
            }
            if (header.getValue() instanceof MediaType) {
                convertedHeaders.put(header.getKey(), header.getValue().toString());
                continue;
            }
            convertedHeaders.put(header.getKey(), header.getValue());
        }
        return convertedHeaders;
    }

    private HttpHeaders createHttpHeaders(HttpMessage httpMessage, HttpEndpointConfiguration endpointConfiguration) {
        HttpHeaders httpHeaders = new HttpHeaders();
        endpointConfiguration.getHeaderMapper().fromHeaders(new MessageHeaders(httpMessage.getHeaders()), (Object)httpHeaders);
        Map messageHeaders = httpMessage.getHeaders();
        for (Map.Entry header : messageHeaders.entrySet()) {
            if (((String)header.getKey()).startsWith("citrus_") || MessageHeaderUtils.isSpringInternalHeader((String)((String)header.getKey())) || httpHeaders.containsKey(header.getKey())) continue;
            httpHeaders.add((String)header.getKey(), header.getValue().toString());
        }
        if (httpHeaders.getFirst("Content-Type") == null) {
            httpHeaders.add("Content-Type", this.composeContentTypeHeaderValue(endpointConfiguration));
        }
        return httpHeaders;
    }

    private HttpMethod determineHttpMethod(HttpEndpointConfiguration endpointConfiguration, HttpMessage httpMessage) {
        HttpMethod method = endpointConfiguration.getRequestMethod();
        if (httpMessage.getRequestMethod() != null) {
            method = httpMessage.getRequestMethod();
        }
        return method;
    }

    private HttpEntity<?> createHttpEntity(HttpHeaders httpHeaders, Object payload, HttpMethod method) {
        if (this.httpMethodSupportsBody(method)) {
            return new HttpEntity(payload, (MultiValueMap)httpHeaders);
        }
        return new HttpEntity((MultiValueMap)httpHeaders);
    }

    private HttpMessage convertOutboundMessage(Message message) {
        HttpMessage httpMessage = message instanceof HttpMessage ? (HttpMessage)message : new HttpMessage(message);
        return httpMessage;
    }

    private boolean httpMethodSupportsBody(HttpMethod method) {
        return HttpMethod.POST.equals((Object)method) || HttpMethod.PUT.equals((Object)method) || HttpMethod.DELETE.equals((Object)method) || HttpMethod.PATCH.equals((Object)method);
    }

    private String composeContentTypeHeaderValue(HttpEndpointConfiguration endpointConfiguration) {
        return endpointConfiguration.getContentType().contains("charset") || !StringUtils.hasText((String)endpointConfiguration.getCharset()) ? endpointConfiguration.getContentType() : endpointConfiguration.getContentType() + ";charset=" + endpointConfiguration.getCharset();
    }

    private Object extractMessageBody(HttpEntity<?> message) {
        return message.getBody() != null ? message.getBody() : "";
    }
}

