/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation;

import com.consol.citrus.builder.WithExpressions;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.validation.context.DefaultValidationContext;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.validation.json.JsonPathMessageValidationContext;
import com.consol.citrus.validation.xml.XpathMessageValidationContext;
import java.util.HashMap;
import java.util.Map;

public class PathExpressionValidationContext {
    private PathExpressionValidationContext() {
    }

    public static final class Builder
    implements ValidationContext.Builder<ValidationContext, Builder>,
    WithExpressions<Builder> {
        private Map<String, Object> expressions = new HashMap<String, Object>();

        public static Builder pathExpression() {
            return new Builder();
        }

        public Builder expressions(Map<String, Object> expressions) {
            this.expressions.putAll(expressions);
            return this;
        }

        public Builder expression(String expression, Object value) {
            this.expressions.put(expression, value);
            return this;
        }

        public Builder jsonPath(String expression, Object value) {
            if (!JsonPathMessageValidationContext.isJsonPathExpression(expression)) {
                throw new CitrusRuntimeException(String.format("Unsupported json path expression '%s'", expression));
            }
            return this.expression(expression, value);
        }

        public Builder xpath(String expression, Object value) {
            if (!XpathMessageValidationContext.isXpathExpression(expression)) {
                throw new CitrusRuntimeException(String.format("Unsupported xpath expression '%s'", expression));
            }
            return this.expression(expression, value);
        }

        public ValidationContext build() {
            if (this.expressions.isEmpty()) {
                return new DefaultValidationContext();
            }
            String expression = this.expressions.keySet().iterator().next();
            if (JsonPathMessageValidationContext.isJsonPathExpression(expression)) {
                return ((JsonPathMessageValidationContext.Builder)new JsonPathMessageValidationContext.Builder().expressions((Map)this.expressions)).build();
            }
            if (XpathMessageValidationContext.isXpathExpression(expression)) {
                return ((XpathMessageValidationContext.Builder)new XpathMessageValidationContext.Builder().expressions((Map)this.expressions)).build();
            }
            throw new CitrusRuntimeException(String.format("Unsupported path expression '%s'", expression));
        }
    }
}

