/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.report;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.report.AbstractTestReporter;
import com.consol.citrus.report.TestResults;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOutputFileReporter
extends AbstractTestReporter {
    private static Logger log = LoggerFactory.getLogger(AbstractOutputFileReporter.class);

    @Override
    public final void generate(TestResults testResults) {
        if (!this.isEnabled()) {
            return;
        }
        this.createReportFile(this.getReportFileName(), this.getReportContent(testResults));
    }

    protected abstract boolean isEnabled();

    protected abstract String getReportContent(TestResults var1);

    protected abstract String getReportFileName();

    private void createReportFile(String reportFileName, String content) {
        File targetDirectory = new File(this.getReportDirectory());
        if (!targetDirectory.exists() && !targetDirectory.mkdirs()) {
            throw new CitrusRuntimeException("Unable to create report output directory: " + this.getReportDirectory());
        }
        try (FileWriter fileWriter = new FileWriter(new File(targetDirectory, reportFileName));){
            ((Writer)fileWriter).append(content);
            ((Writer)fileWriter).flush();
            log.info("Generated test report: " + targetDirectory + File.separator + reportFileName);
        }
        catch (IOException e) {
            log.error("Failed to create test report", (Throwable)e);
        }
    }
}

