/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.message.builder;

import com.consol.citrus.AbstractTestActionBuilder;
import com.consol.citrus.CitrusSettings;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.common.Named;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageBuilder;
import com.consol.citrus.message.MessageHeaderBuilder;
import com.consol.citrus.message.MessageHeaderDataBuilder;
import com.consol.citrus.message.MessagePayloadBuilder;
import com.consol.citrus.message.MessageProcessor;
import com.consol.citrus.message.MessageProcessorAdapter;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.message.WithHeaderBuilder;
import com.consol.citrus.message.WithPayloadBuilder;
import com.consol.citrus.message.builder.DefaultHeaderBuilder;
import com.consol.citrus.message.builder.DefaultHeaderDataBuilder;
import com.consol.citrus.message.builder.DefaultPayloadBuilder;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.validation.builder.DefaultMessageBuilder;
import com.consol.citrus.validation.builder.StaticMessageBuilder;
import com.consol.citrus.variable.VariableExtractor;
import com.consol.citrus.variable.VariableExtractorAdapter;
import com.consol.citrus.variable.dictionary.DataDictionary;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.Resource;

public abstract class MessageBuilderSupport<T extends TestAction, B extends MessageActionBuilder<T, S, B>, S extends MessageBuilderSupport<T, B, S>>
implements TestActionBuilder<T>,
ReferenceResolverAware {
    protected final S self;
    protected MessageBuilder messageBuilder = new DefaultMessageBuilder();
    protected final B delegate;
    protected String messageType = CitrusSettings.DEFAULT_MESSAGE_TYPE;
    protected DataDictionary<?> dataDictionary;
    protected String dataDictionaryName;

    protected MessageBuilderSupport(B delegate) {
        this.self = this;
        this.delegate = delegate;
    }

    public S from(MessageBuilder messageBuilder) {
        this.messageBuilder = messageBuilder;
        return this.self;
    }

    public S from(Message controlMessage) {
        this.messageBuilder = StaticMessageBuilder.withMessage(controlMessage);
        this.type(controlMessage.getType());
        return this.self;
    }

    public S type(MessageType messageType) {
        this.type(messageType.name());
        return this.self;
    }

    public S type(String messageType) {
        this.messageType = messageType;
        return this.self;
    }

    public S body(MessagePayloadBuilder.Builder<?, ?> payloadBuilder) {
        this.body(payloadBuilder.build());
        return this.self;
    }

    public S body(MessagePayloadBuilder payloadBuilder) {
        if (!(this.messageBuilder instanceof WithPayloadBuilder)) {
            throw new CitrusRuntimeException("Unable to set payload builder on message builder type: " + this.messageBuilder.getClass());
        }
        ((WithPayloadBuilder)this.messageBuilder).setPayloadBuilder(payloadBuilder);
        return this.self;
    }

    public S body(String payload) {
        this.body(new DefaultPayloadBuilder(payload));
        return this.self;
    }

    public S body(Resource payloadResource) {
        return this.body(payloadResource, FileUtils.getDefaultCharset());
    }

    public S body(Resource payloadResource, Charset charset) {
        try {
            this.body(FileUtils.readToString(payloadResource, charset));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read payload resource", (Throwable)e);
        }
        return this.self;
    }

    public S header(String name, Object value) {
        if (!(this.messageBuilder instanceof WithHeaderBuilder)) {
            throw new CitrusRuntimeException("Unable to set message header on builder type: " + this.messageBuilder.getClass());
        }
        ((WithHeaderBuilder)this.messageBuilder).addHeaderBuilder((MessageHeaderBuilder)new DefaultHeaderBuilder(Collections.singletonMap(name, value)));
        return this.self;
    }

    public S headers(Map<String, Object> headers) {
        if (!(this.messageBuilder instanceof WithHeaderBuilder)) {
            throw new CitrusRuntimeException("Unable to set message header on builder type: " + this.messageBuilder.getClass());
        }
        ((WithHeaderBuilder)this.messageBuilder).addHeaderBuilder((MessageHeaderBuilder)new DefaultHeaderBuilder(headers));
        return this.self;
    }

    public S header(String data) {
        this.header(new DefaultHeaderDataBuilder(data));
        return this.self;
    }

    public S header(MessageHeaderDataBuilder headerDataBuilder) {
        if (!(this.messageBuilder instanceof WithHeaderBuilder)) {
            throw new CitrusRuntimeException("Unable to set message header data on builder type: " + this.messageBuilder.getClass());
        }
        ((WithHeaderBuilder)this.messageBuilder).addHeaderBuilder((MessageHeaderBuilder)headerDataBuilder);
        return this.self;
    }

    public S header(Resource resource) {
        return this.header(resource, FileUtils.getDefaultCharset());
    }

    public S header(Resource resource, Charset charset) {
        try {
            if (!(this.messageBuilder instanceof WithHeaderBuilder)) {
                throw new CitrusRuntimeException("Unable to set message header data on builder type: " + this.messageBuilder.getClass());
            }
            ((WithHeaderBuilder)this.messageBuilder).addHeaderBuilder((MessageHeaderBuilder)new DefaultHeaderDataBuilder(FileUtils.readToString(resource, charset)));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read header resource", (Throwable)e);
        }
        return this.self;
    }

    public S name(String name) {
        if (!(this.messageBuilder instanceof Named)) {
            throw new CitrusRuntimeException("Unable to set message name on builder type: " + this.messageBuilder.getClass());
        }
        ((Named)this.messageBuilder).setName(name);
        return this.self;
    }

    public S process(MessageProcessor processor) {
        ((MessageActionBuilder)this.delegate).process(processor);
        return this.self;
    }

    public S process(MessageProcessor.Builder<?, ?> builder) {
        return this.process(builder.build());
    }

    public S process(MessageProcessorAdapter adapter) {
        return this.process(adapter.asProcessor());
    }

    public S extract(VariableExtractor extractor) {
        return this.process((MessageProcessor)extractor);
    }

    public S extract(VariableExtractorAdapter adapter) {
        return this.extract(adapter.asExtractor());
    }

    public S extract(VariableExtractor.Builder<?, ?> builder) {
        return this.extract(builder.build());
    }

    public S dictionary(DataDictionary<?> dictionary) {
        this.dataDictionary = dictionary;
        return this.self;
    }

    public S dictionary(String dictionaryName) {
        this.dataDictionaryName = dictionaryName;
        return this.self;
    }

    public S withReferenceResolver(ReferenceResolver referenceResolver) {
        ((MessageActionBuilder)this.delegate).withReferenceResolver(referenceResolver);
        return this.self;
    }

    public T build() {
        return (T)this.delegate.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        ((MessageActionBuilder)this.delegate).setReferenceResolver(referenceResolver);
    }

    public String getDataDictionaryName() {
        return this.dataDictionaryName;
    }

    public DataDictionary<?> getDataDictionary() {
        return this.dataDictionary;
    }

    public MessageBuilder getMessageBuilder() {
        return this.messageBuilder;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public static abstract class MessageActionBuilder<T extends TestAction, M extends MessageBuilderSupport<T, B, M>, B extends MessageActionBuilder<T, M, B>>
    extends AbstractTestActionBuilder<T, B>
    implements ReferenceResolverAware {
        protected Endpoint endpoint;
        protected String endpointUri;
        protected final List<VariableExtractor> variableExtractors = new ArrayList<VariableExtractor>();
        protected final List<MessageProcessor> messageProcessors = new ArrayList<MessageProcessor>();
        protected M messageBuilderSupport;
        protected ReferenceResolver referenceResolver;

        public B endpoint(Endpoint messageEndpoint) {
            this.endpoint = messageEndpoint;
            return (B)((MessageActionBuilder)this.self);
        }

        public B endpoint(String messageEndpointUri) {
            this.endpointUri = messageEndpointUri;
            return (B)((MessageActionBuilder)this.self);
        }

        public M message() {
            return this.getMessageBuilderSupport();
        }

        public M message(MessageBuilder messageBuilder) {
            return (M)((MessageBuilderSupport)this.getMessageBuilderSupport()).from(messageBuilder);
        }

        public M message(Message controlMessage) {
            return (M)((MessageBuilderSupport)this.getMessageBuilderSupport()).from(controlMessage);
        }

        public B transform(MessageProcessor processor) {
            return this.process(processor);
        }

        public B transform(MessageProcessorAdapter adapter) {
            return this.process(adapter);
        }

        public B transform(MessageProcessor.Builder<?, ?> builder) {
            return this.transform(builder.build());
        }

        public B process(MessageProcessor processor) {
            if (processor instanceof VariableExtractor) {
                this.variableExtractors.add((VariableExtractor)processor);
            } else {
                this.messageProcessors.add(processor);
            }
            return (B)((MessageActionBuilder)this.self);
        }

        public B process(MessageProcessor.Builder<?, ?> builder) {
            return this.process(builder.build());
        }

        public B process(MessageProcessorAdapter adapter) {
            return this.process(adapter.asProcessor());
        }

        public void setReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
        }

        public B withReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
            return (B)((MessageActionBuilder)this.self);
        }

        public M getMessageBuilderSupport() {
            return this.messageBuilderSupport;
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        public String getEndpointUri() {
            return this.endpointUri;
        }

        public List<VariableExtractor> getVariableExtractors() {
            return this.variableExtractors;
        }

        public List<MessageProcessor> getMessageProcessors() {
            return this.messageProcessors;
        }

        protected abstract T doBuild();
    }
}

