/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.functions.core;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.InvalidFunctionUsageException;
import com.consol.citrus.functions.Function;
import com.consol.citrus.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.springframework.util.CollectionUtils;
import org.springframework.util.FileCopyUtils;

public class ReadFileResourceFunction
implements Function {
    public String execute(List<String> parameterList, TestContext context) {
        if (CollectionUtils.isEmpty(parameterList)) {
            throw new InvalidFunctionUsageException("Missing file path function parameter");
        }
        boolean base64 = parameterList.size() > 1 && Boolean.parseBoolean(parameterList.get(1));
        try {
            if (base64) {
                if (parameterList.size() > 2 && Boolean.parseBoolean(parameterList.get(2))) {
                    return Base64.encodeBase64String((byte[])this.readFileContent(parameterList.get(0), context, true).getBytes(FileUtils.getCharset(parameterList.get(0))));
                }
                return Base64.encodeBase64String((byte[])FileCopyUtils.copyToByteArray((InputStream)FileUtils.getFileResource(parameterList.get(0), context).getInputStream()));
            }
            return this.readFileContent(parameterList.get(0), context, true);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read file", (Throwable)e);
        }
    }

    private String readFileContent(String filePath, TestContext context, boolean replace) throws IOException {
        String content = FileUtils.readToString(FileUtils.getFileResource(filePath, context), FileUtils.getCharset(filePath));
        return replace ? context.replaceDynamicContentInString(content) : content;
    }
}

