/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.endpoint;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.endpoint.EndpointComponent;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.util.TypeConversionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractEndpointComponent
implements EndpointComponent {
    private final String name;

    public AbstractEndpointComponent(String name) {
        this.name = name;
    }

    public Endpoint createEndpoint(String endpointUri, TestContext context) {
        try {
            Endpoint endpoint;
            URI uri = new URI(endpointUri);
            String path = uri.getSchemeSpecificPart();
            if (path.startsWith("//")) {
                path = path.substring(2);
            }
            if (path.contains("?")) {
                path = path.substring(0, path.indexOf(63));
            }
            Map<String, String> parameters = this.getParameters(endpointUri);
            String endpointName = null;
            if (parameters.containsKey("endpointName")) {
                endpointName = parameters.remove("endpointName");
            }
            if ((endpoint = this.createEndpoint(path, parameters, context)) instanceof ReferenceResolverAware) {
                ((ReferenceResolverAware)endpoint).setReferenceResolver(context.getReferenceResolver());
            }
            if (StringUtils.hasText((String)endpointName)) {
                endpoint.setName(endpointName);
            }
            return endpoint;
        }
        catch (URISyntaxException e) {
            throw new CitrusRuntimeException(String.format("Unable to parse endpoint uri '%s'", endpointUri), (Throwable)e);
        }
    }

    public Map<String, String> getParameters(String endpointUri) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (endpointUri.contains("?")) {
            String parameterString = endpointUri.substring(endpointUri.indexOf(63) + 1);
            StringTokenizer tok = new StringTokenizer(parameterString, "&");
            while (tok.hasMoreElements()) {
                Object[] parameterValue = tok.nextToken().split("=");
                if (parameterValue.length == 1) {
                    parameters.put(parameterValue[0], null);
                    continue;
                }
                if (parameterValue.length == 2) {
                    parameters.put(parameterValue[0], parameterValue[1]);
                    continue;
                }
                throw new CitrusRuntimeException(String.format("Invalid parameter key/value combination '%s'", Arrays.toString(parameterValue)));
            }
        }
        return parameters;
    }

    protected void enrichEndpointConfiguration(EndpointConfiguration endpointConfiguration, Map<String, String> parameters, TestContext context) {
        for (Map.Entry<String, String> parameterEntry : parameters.entrySet()) {
            Field field = ReflectionUtils.findField(endpointConfiguration.getClass(), (String)parameterEntry.getKey());
            if (field == null) {
                throw new CitrusRuntimeException(String.format("Unable to find parameter field on endpoint configuration '%s'", parameterEntry.getKey()));
            }
            Method setter = ReflectionUtils.findMethod(endpointConfiguration.getClass(), (String)("set" + parameterEntry.getKey().substring(0, 1).toUpperCase() + parameterEntry.getKey().substring(1)), (Class[])new Class[]{field.getType()});
            if (setter == null) {
                throw new CitrusRuntimeException(String.format("Unable to find parameter setter on endpoint configuration '%s'", "set" + parameterEntry.getKey().substring(0, 1).toUpperCase() + parameterEntry.getKey().substring(1)));
            }
            if (parameterEntry.getValue() != null) {
                ReflectionUtils.invokeMethod((Method)setter, (Object)endpointConfiguration, (Object[])new Object[]{TypeConversionUtils.convertStringToType((String)parameterEntry.getValue(), field.getType(), (TestContext)context)});
                continue;
            }
            ReflectionUtils.invokeMethod((Method)setter, (Object)endpointConfiguration, (Object[])new Object[]{field.getType().cast(null)});
        }
    }

    protected Map<String, String> getEndpointConfigurationParameters(Map<String, String> parameters, Class<? extends EndpointConfiguration> endpointConfigurationType) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, String> parameterEntry : parameters.entrySet()) {
            Field field = ReflectionUtils.findField(endpointConfigurationType, (String)parameterEntry.getKey());
            if (field == null) continue;
            params.put(parameterEntry.getKey(), parameterEntry.getValue());
        }
        return params;
    }

    protected String getParameterString(Map<String, String> parameters, Class<? extends EndpointConfiguration> endpointConfigurationType) {
        StringBuilder paramString = new StringBuilder();
        for (Map.Entry<String, String> parameterEntry : parameters.entrySet()) {
            Field field = ReflectionUtils.findField(endpointConfigurationType, (String)parameterEntry.getKey());
            if (field != null) continue;
            if (paramString.length() == 0) {
                paramString.append("?").append(parameterEntry.getKey());
                if (parameterEntry.getValue() == null) continue;
                paramString.append("=").append(parameterEntry.getValue());
                continue;
            }
            paramString.append("&").append(parameterEntry.getKey());
            if (parameterEntry.getValue() == null) continue;
            paramString.append("=").append(parameterEntry.getValue());
        }
        return paramString.toString();
    }

    protected abstract Endpoint createEndpoint(String var1, Map<String, String> var2, TestContext var3);

    public String getName() {
        return this.name;
    }
}

