/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.AbstractSuiteContainerBuilder;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.container.AbstractSuiteActionContainer;
import com.consol.citrus.container.AfterSuite;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceAfterSuite
extends AbstractSuiteActionContainer
implements AfterSuite {
    private static Logger log = LoggerFactory.getLogger(SequenceAfterSuite.class);

    @Override
    public void doExecute(TestContext context) {
        boolean success = true;
        log.info("Entering after suite block");
        if (log.isDebugEnabled()) {
            log.debug("Executing " + this.actions.size() + " actions after suite");
            log.debug("");
        }
        for (TestActionBuilder actionBuilder : this.actions) {
            TestAction action = actionBuilder.build();
            try {
                action.execute(context);
            }
            catch (Exception e) {
                log.error("After suite action failed " + action.getName() + "Nested exception is: ", (Throwable)e);
                log.error("Continue after suite actions");
                success = false;
            }
        }
        if (!success) {
            throw new CitrusRuntimeException("Error in after suite");
        }
    }

    public static class Builder
    extends AbstractSuiteContainerBuilder<SequenceAfterSuite, Builder> {
        public static Builder afterSuite() {
            return new Builder();
        }

        @Override
        public SequenceAfterSuite doBuild() {
            return new SequenceAfterSuite();
        }
    }
}

