/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.AbstractExceptionContainerBuilder;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.container.AbstractActionContainer;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Catch
extends AbstractActionContainer {
    private final String exception;
    private static Logger log = LoggerFactory.getLogger(Catch.class);

    public Catch(Builder builder) {
        super("catch", builder);
        this.exception = builder.exception;
    }

    @Override
    public void doExecute(TestContext context) {
        if (log.isDebugEnabled()) {
            log.debug("Catch container catching exceptions of type " + this.exception);
        }
        for (TestActionBuilder actionBuilder : this.actions) {
            try {
                this.executeAction(actionBuilder.build(), context);
            }
            catch (Exception e) {
                if (this.exception != null && this.exception.equals(e.getClass().getName())) {
                    log.info("Caught exception " + e.getClass() + ": " + e.getLocalizedMessage());
                    continue;
                }
                throw new CitrusRuntimeException((Throwable)e);
            }
        }
    }

    public String getException() {
        return this.exception;
    }

    public static class Builder
    extends AbstractExceptionContainerBuilder<Catch, Builder> {
        private String exception = CitrusRuntimeException.class.getName();

        public static Builder catchException() {
            return new Builder();
        }

        public Builder exception(Class<? extends Throwable> exception) {
            this.exception = exception.getName();
            return this;
        }

        public Builder exception(String type) {
            this.exception = type;
            return this;
        }

        @Override
        public Catch doBuild() {
            return new Catch(this);
        }
    }
}

