/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.AbstractIteratingContainerBuilder;
import com.consol.citrus.AbstractTestContainerBuilder;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.container.AbstractActionContainer;
import com.consol.citrus.container.IteratingConditionExpression;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.util.BooleanExpressionParser;
import com.consol.citrus.validation.matcher.ValidationMatcherUtils;
import java.util.Properties;
import org.springframework.util.PropertyPlaceholderHelper;

public abstract class AbstractIteratingActionContainer
extends AbstractActionContainer {
    protected final String condition;
    protected final IteratingConditionExpression conditionExpression;
    protected final String indexName;
    protected final int start;
    protected int index;

    public AbstractIteratingActionContainer(String name, AbstractIteratingContainerBuilder<?, ?> builder) {
        super(name, (AbstractTestContainerBuilder<?, ?>)builder);
        this.condition = builder.getCondition();
        this.conditionExpression = builder.getConditionExpression();
        this.indexName = builder.getIndexName();
        this.index = builder.getIndex();
        this.start = builder.getStart();
    }

    @Override
    public final void doExecute(TestContext context) {
        this.index = this.start;
        this.executeIteration(context);
    }

    protected abstract void executeIteration(TestContext var1);

    protected void executeActions(TestContext context) {
        context.setVariable(this.indexName, (Object)String.valueOf(this.index));
        for (TestActionBuilder actionBuilder : this.actions) {
            this.executeAction(actionBuilder.build(), context);
        }
    }

    protected boolean checkCondition(TestContext context) {
        if (this.conditionExpression != null) {
            return this.conditionExpression.evaluate(this.index, context);
        }
        String conditionString = this.condition;
        if (conditionString.contains("${" + this.indexName + "}")) {
            Properties props = new Properties();
            props.put(this.indexName, String.valueOf(this.index));
            conditionString = new PropertyPlaceholderHelper("${", "}").replacePlaceholders(conditionString, props);
        }
        if (ValidationMatcherUtils.isValidationMatcherExpression((String)(conditionString = context.replaceDynamicContentInString(conditionString)))) {
            try {
                ValidationMatcherUtils.resolveValidationMatcher((String)"iteratingCondition", (String)String.valueOf(this.index), (String)conditionString, (TestContext)context);
                return true;
            }
            catch (ValidationException | AssertionError e) {
                return false;
            }
        }
        if (conditionString.indexOf(this.indexName) != -1) {
            conditionString = conditionString.replaceAll(this.indexName, String.valueOf(this.index));
        }
        return BooleanExpressionParser.evaluate(conditionString);
    }

    @Override
    public boolean isDone(TestContext context) {
        return super.isDone(context) || !this.checkCondition(context);
    }

    public String getCondition() {
        return this.condition;
    }

    public IteratingConditionExpression getConditionExpression() {
        return this.conditionExpression;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public int getIndex() {
        return this.index;
    }

    public int getStart() {
        return this.start;
    }
}

