/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.DistributedLockConnector;
import com.coditory.sherlock.LockId;
import com.coditory.sherlock.LockRequest;
import com.coditory.sherlock.MongoCollectionInitializer;
import com.coditory.sherlock.MongoDistributedLock;
import com.coditory.sherlock.MongoDistributedLockQueries;
import com.coditory.sherlock.OwnerId;
import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.SherlockException;
import com.mongodb.MongoCommandException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.result.DeleteResult;
import java.time.Clock;
import java.time.Instant;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;

class MongoDistributedLockConnector
implements DistributedLockConnector {
    private static final int DUPLICATE_KEY_ERROR_CODE = 11000;
    private static final FindOneAndReplaceOptions upsertOptions = new FindOneAndReplaceOptions().upsert(true).returnDocument(ReturnDocument.AFTER);
    private final MongoCollectionInitializer collectionInitializer;
    private final Clock clock;

    MongoDistributedLockConnector(MongoCollection<Document> collection, Clock clock) {
        Preconditions.expectNonNull(collection, (String)"Expected non null collection");
        this.collectionInitializer = new MongoCollectionInitializer(collection);
        this.clock = (Clock)Preconditions.expectNonNull((Object)clock, (String)"Expected non null clock");
    }

    public void initialize() {
        try {
            this.collectionInitializer.getInitializedCollection();
        }
        catch (Throwable e) {
            throw new SherlockException("Could not initialize Mongo collection", e);
        }
    }

    public boolean acquire(LockRequest lockRequest) {
        Instant now = this.now();
        try {
            return this.upsert(MongoDistributedLockQueries.queryReleased((LockId)lockRequest.getLockId(), (Instant)now), MongoDistributedLock.fromLockRequest((LockRequest)lockRequest, (Instant)now));
        }
        catch (Throwable e) {
            throw new SherlockException("Could not acquire lock: " + lockRequest, e);
        }
    }

    public boolean acquireOrProlong(LockRequest lockRequest) {
        Instant now = this.now();
        try {
            return this.upsert(MongoDistributedLockQueries.queryAcquiredOrReleased((LockId)lockRequest.getLockId(), (OwnerId)lockRequest.getOwnerId(), (Instant)now), MongoDistributedLock.fromLockRequest((LockRequest)lockRequest, (Instant)now));
        }
        catch (Throwable e) {
            throw new SherlockException("Could not acquire or prolong lock: " + lockRequest, e);
        }
    }

    public boolean forceAcquire(LockRequest lockRequest) {
        try {
            return this.upsert(MongoDistributedLockQueries.queryById((LockId)lockRequest.getLockId()), MongoDistributedLock.fromLockRequest((LockRequest)lockRequest, (Instant)this.now()));
        }
        catch (Throwable e) {
            throw new SherlockException("Could not acquire or prolong lock: " + lockRequest, e);
        }
    }

    public boolean release(LockId lockId, OwnerId ownerId) {
        try {
            return this.delete(MongoDistributedLockQueries.queryAcquired((LockId)lockId, (OwnerId)ownerId));
        }
        catch (Throwable e) {
            throw new SherlockException("Could not release lock: " + lockId.getValue() + ", owner: " + ownerId, e);
        }
    }

    public boolean forceRelease(LockId lockId) {
        try {
            return this.delete(MongoDistributedLockQueries.queryById((LockId)lockId));
        }
        catch (Throwable e) {
            throw new SherlockException("Could not force release lock: " + lockId.getValue(), e);
        }
    }

    public boolean forceReleaseAll() {
        try {
            return this.deleteAll();
        }
        catch (Throwable e) {
            throw new SherlockException("Could not force release all locks", e);
        }
    }

    private boolean deleteAll() {
        DeleteResult result = this.getLockCollection().deleteMany((Bson)new BsonDocument());
        return result.getDeletedCount() > 0L;
    }

    private boolean delete(Bson query) {
        Document deleted = (Document)this.getLockCollection().findOneAndDelete(query);
        return deleted != null && MongoDistributedLock.fromDocument((Document)deleted).isActive(this.now());
    }

    private boolean upsert(Bson query, MongoDistributedLock lock) {
        Document documentToUpsert = lock.toDocument();
        try {
            Document current = (Document)this.getLockCollection().findOneAndReplace(query, (Object)documentToUpsert, upsertOptions);
            return lock.hasSameOwner(current);
        }
        catch (MongoCommandException exception) {
            if (exception.getErrorCode() != 11000) {
                throw exception;
            }
            return false;
        }
    }

    private Instant now() {
        return this.clock.instant();
    }

    private MongoCollection<Document> getLockCollection() {
        return this.collectionInitializer.getInitializedCollection();
    }
}

