/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.DistributedLockConnector;
import com.coditory.sherlock.InMemoryDistributedLockConnector;
import com.coditory.sherlock.InMemoryDistributedLockStorage;
import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.Sherlock;
import com.coditory.sherlock.SherlockDefaults;
import com.coditory.sherlock.SherlockWithConnectorBuilder;
import java.time.Clock;

public final class InMemorySherlockBuilder
extends SherlockWithConnectorBuilder<InMemorySherlockBuilder> {
    private Clock clock = SherlockDefaults.DEFAULT_CLOCK;
    private InMemoryDistributedLockStorage storage = new InMemoryDistributedLockStorage();

    public static InMemorySherlockBuilder inMemorySherlockBuilder() {
        return new InMemorySherlockBuilder();
    }

    public static Sherlock inMemorySherlock() {
        return InMemorySherlockBuilder.inMemorySherlockBuilder().build();
    }

    private InMemorySherlockBuilder() {
    }

    public InMemorySherlockBuilder withClock(Clock clock) {
        this.clock = (Clock)Preconditions.expectNonNull((Object)clock, (String)"Expected non null clock");
        return this;
    }

    public InMemorySherlockBuilder withSharedStorage() {
        this.storage = InMemoryDistributedLockStorage.singleton();
        return this;
    }

    public Sherlock build() {
        InMemoryDistributedLockConnector connector = new InMemoryDistributedLockConnector(this.clock, this.storage);
        return super.build((DistributedLockConnector)connector);
    }
}

