/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.DistributedLockConnector;
import com.coditory.sherlock.InMemoryDistributedLockStorage;
import com.coditory.sherlock.LockId;
import com.coditory.sherlock.LockRequest;
import com.coditory.sherlock.OwnerId;
import java.time.Clock;
import java.time.Instant;

class InMemoryDistributedLockConnector
implements DistributedLockConnector {
    private final InMemoryDistributedLockStorage storage;
    private final Clock clock;

    InMemoryDistributedLockConnector(Clock clock, InMemoryDistributedLockStorage storage) {
        this.storage = storage;
        this.clock = clock;
    }

    public void initialize() {
    }

    public synchronized boolean acquire(LockRequest lockRequest) {
        return this.storage.acquire(lockRequest, this.now());
    }

    public synchronized boolean acquireOrProlong(LockRequest lockRequest) {
        return this.storage.acquireOrProlong(lockRequest, this.now());
    }

    public synchronized boolean forceAcquire(LockRequest lockRequest) {
        return this.storage.forceAcquire(lockRequest, this.now());
    }

    public synchronized boolean release(LockId lockId, OwnerId ownerId) {
        return this.storage.release(lockId, this.now(), ownerId);
    }

    public synchronized boolean forceRelease(LockId lockId) {
        return this.storage.forceRelease(lockId, this.now());
    }

    public boolean forceReleaseAll() {
        return this.storage.forceReleaseAll(this.now());
    }

    private Instant now() {
        return this.clock.instant();
    }
}

