/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack;

import com.codepoetics.protonpack.comparators.Comparators;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;

class WindowedSpliterator<T>
implements Spliterator<List<T>> {
    private final Spliterator<T> source;
    private final int windowSize;
    private int overlap;
    private boolean allowLesserSize;
    List<T> queue = new LinkedList<T>();
    List<T> next = new LinkedList<T>();
    private boolean windowSeeded;

    public WindowedSpliterator(Spliterator<T> input, int windowSize, int overlap, boolean allowLesserSize) {
        this.source = input;
        this.windowSize = windowSize;
        this.overlap = overlap;
        this.allowLesserSize = allowLesserSize;
    }

    static <T> WindowedSpliterator<T> over(Spliterator<T> source, int windowSize, int overlap, boolean allowLesserSize) {
        return new WindowedSpliterator<T>(source, windowSize, overlap, allowLesserSize);
    }

    private boolean hasNext() {
        if (!this.windowSeeded) {
            this.seedWindow();
            this.windowSeeded = true;
        }
        return this.next.size() > 0;
    }

    private void nextWindow() {
        for (int i = 0; i < this.overlap; ++i) {
            if (this.next.isEmpty()) {
                return;
            }
            this.next.remove(0);
            this.source.tryAdvance(this.next::add);
        }
    }

    private void seedWindow() {
        int window = this.windowSize;
        while (this.source.tryAdvance(this.next::add)) {
            if (--window != 0) continue;
            return;
        }
    }

    private List<T> next() {
        this.queue = new LinkedList<T>(this.next);
        this.nextWindow();
        if (!this.allowLesserSize && this.next.size() != this.windowSize) {
            this.next.clear();
        }
        return this.queue;
    }

    @Override
    public boolean tryAdvance(Consumer<? super List<T>> action) {
        if (this.hasNext()) {
            action.accept(this.next());
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<List<T>> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        long sourceSize = this.source.estimateSize();
        if (sourceSize == 0L) {
            return 0L;
        }
        if (sourceSize <= (long)this.windowSize) {
            return 1L;
        }
        return sourceSize - (long)this.windowSize;
    }

    @Override
    public int characteristics() {
        return this.source.characteristics() & 0xFFFFFFAF;
    }

    @Override
    public Comparator<? super List<T>> getComparator() {
        Comparator<T> comparator = this.source.getComparator();
        return comparator == null ? null : Comparators.toListComparator(comparator);
    }
}

