/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ThreadLocalSelenideDriver;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.WebDriverContainer;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.WebDriverListener;

public class WebDriverRunner {
    private static final WebDriverContainer webdriverContainer = (WebDriverContainer)Plugins.inject(WebDriverContainer.class);
    private static final ThreadLocalSelenideDriver staticSelenideDriver = new ThreadLocalSelenideDriver();

    public static void addListener(WebDriverListener listener) {
        webdriverContainer.addListener(listener);
    }

    public static void removeListener(WebDriverListener listener) {
        webdriverContainer.removeListener(listener);
    }

    public static void setWebDriver(WebDriver webDriver) {
        webdriverContainer.setWebDriver(webDriver);
    }

    public static void setWebDriver(WebDriver webDriver, @Nullable SelenideProxyServer selenideProxy) {
        webdriverContainer.setWebDriver(webDriver, selenideProxy);
    }

    public static void setWebDriver(WebDriver webDriver, @Nullable SelenideProxyServer selenideProxy, DownloadsFolder browserDownloadsFolder) {
        webdriverContainer.setWebDriver(webDriver, selenideProxy, browserDownloadsFolder);
    }

    public static WebDriver getWebDriver() {
        return webdriverContainer.getWebDriver();
    }

    public static void setProxy(@Nullable Proxy webProxy) {
        webdriverContainer.setProxy(webProxy);
    }

    public static WebDriver getAndCheckWebDriver() {
        return webdriverContainer.getAndCheckWebDriver();
    }

    public static SelenideProxyServer getSelenideProxy() {
        return webdriverContainer.getProxyServer();
    }

    static ThreadLocalSelenideDriver getSelenideDriver() {
        return staticSelenideDriver;
    }

    public static Driver driver() {
        return WebDriverRunner.getSelenideDriver().driver();
    }

    public static @Nullable DownloadsFolder getBrowserDownloadsFolder() {
        return webdriverContainer.getBrowserDownloadsFolder();
    }

    public static void closeWindow() {
        webdriverContainer.closeWindow();
    }

    @Deprecated
    public static void closeWebDriver() {
        webdriverContainer.closeWebDriver();
    }

    public static boolean hasWebDriverStarted() {
        return webdriverContainer.hasWebDriverStarted();
    }

    static void using(WebDriver driver, Runnable lambda) {
        webdriverContainer.using(driver, null, null, lambda);
    }

    static void using(WebDriver driver, SelenideProxyServer proxy, Runnable lambda) {
        webdriverContainer.using(driver, proxy, null, lambda);
    }

    static void inNewBrowser(Runnable lambda) {
        webdriverContainer.inNewBrowser(lambda);
    }

    static void inNewBrowser(Config config, Runnable lambda) {
        webdriverContainer.inNewBrowser(config, lambda);
    }

    private static Browser browser() {
        return new Browser(Configuration.browser, Configuration.headless);
    }

    public static boolean isFirefox() {
        return WebDriverRunner.browser().isFirefox();
    }

    public static boolean isChrome() {
        return WebDriverRunner.browser().isChrome();
    }

    public static boolean isIE() {
        return WebDriverRunner.browser().isIE();
    }

    public static boolean isEdge() {
        return WebDriverRunner.browser().isEdge();
    }

    public static boolean isHeadless() {
        return WebDriverRunner.browser().isHeadless();
    }

    public static boolean supportsJavascript() {
        return WebDriverRunner.driver().supportsJavascript();
    }

    public static void clearBrowserCache() {
        webdriverContainer.clearBrowserCache();
    }

    public static @Nullable String source() {
        return webdriverContainer.getPageSource();
    }

    public static @Nullable String url() {
        return webdriverContainer.getCurrentUrl();
    }

    public static String currentFrameUrl() {
        return webdriverContainer.getCurrentFrameUrl();
    }
}

