/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SharedDownloadsFolder;
import com.codeborne.selenide.drivercommands.BrowserHealthChecker;
import com.codeborne.selenide.drivercommands.CloseDriverCommand;
import com.codeborne.selenide.drivercommands.CreateDriverCommand;
import com.codeborne.selenide.impl.StaticConfig;
import com.codeborne.selenide.impl.UnusedWebdriversCleanupThread;
import com.codeborne.selenide.impl.WebDriverContainer;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import com.codeborne.selenide.webdriver.WebDriverFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;
import org.openqa.selenium.support.events.WebDriverListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class WebDriverThreadLocalContainer
implements WebDriverContainer {
    private static final Logger log = LoggerFactory.getLogger(WebDriverThreadLocalContainer.class);
    private final List<WebDriverEventListener> eventListeners = new ArrayList<WebDriverEventListener>();
    private final List<WebDriverListener> listeners = new ArrayList<WebDriverListener>();
    final Collection<Thread> allWebDriverThreads = new ConcurrentLinkedQueue<Thread>();
    final Map<Long, WebDriver> threadWebDriver = new ConcurrentHashMap<Long, WebDriver>(4);
    private final Map<Long, SelenideProxyServer> threadProxyServer = new ConcurrentHashMap<Long, SelenideProxyServer>(4);
    private final Map<Long, DownloadsFolder> threadDownloadsFolder = new ConcurrentHashMap<Long, DownloadsFolder>(4);
    @Nullable
    private Proxy userProvidedProxy;
    private final Config config = new StaticConfig();
    private final BrowserHealthChecker browserHealthChecker = new BrowserHealthChecker();
    private final WebDriverFactory factory = new WebDriverFactory();
    private final CloseDriverCommand closeDriverCommand = new CloseDriverCommand();
    private final CreateDriverCommand createDriverCommand = new CreateDriverCommand();
    final AtomicBoolean cleanupThreadStarted = new AtomicBoolean(false);

    @Override
    public void addListener(WebDriverEventListener listener) {
        this.eventListeners.add(listener);
    }

    @Override
    public void addListener(WebDriverListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(WebDriverEventListener listener) {
        this.eventListeners.remove(listener);
    }

    @Override
    public void removeListener(WebDriverListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setWebDriver(WebDriver webDriver) {
        this.setWebDriver(webDriver, null);
    }

    @Override
    public void setWebDriver(WebDriver webDriver, @Nullable SelenideProxyServer selenideProxy) {
        this.setWebDriver(webDriver, selenideProxy, (DownloadsFolder)new SharedDownloadsFolder(this.config.downloadsFolder()));
    }

    @Override
    public void setWebDriver(WebDriver webDriver, @Nullable SelenideProxyServer selenideProxy, DownloadsFolder browserDownloadsFolder) {
        this.resetWebDriver();
        long threadId = Thread.currentThread().getId();
        if (selenideProxy != null) {
            this.threadProxyServer.put(threadId, selenideProxy);
        }
        this.threadWebDriver.put(threadId, webDriver);
        this.threadDownloadsFolder.put(threadId, browserDownloadsFolder);
    }

    @Override
    public void resetWebDriver() {
        long threadId = Thread.currentThread().getId();
        this.threadProxyServer.remove(threadId);
        this.threadWebDriver.remove(threadId);
        this.threadDownloadsFolder.remove(threadId);
    }

    @Override
    public void setProxy(@Nullable Proxy userProvidedProxy) {
        this.userProvidedProxy = userProvidedProxy;
    }

    @Override
    @CheckReturnValue
    public boolean hasWebDriverStarted() {
        WebDriver webDriver = this.threadWebDriver.get(Thread.currentThread().getId());
        return webDriver != null;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebDriver getWebDriver() {
        long threadId = Thread.currentThread().getId();
        if (!this.threadWebDriver.containsKey(threadId)) {
            throw new IllegalStateException("No webdriver is bound to current thread: " + threadId + ". You need to call open(url) first.");
        }
        return this.threadWebDriver.get(threadId);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebDriver getAndCheckWebDriver() {
        WebDriver webDriver = this.threadWebDriver.get(Thread.currentThread().getId());
        if (webDriver != null && this.config.reopenBrowserOnFail() && !this.browserHealthChecker.isBrowserStillOpen(webDriver)) {
            log.info("Webdriver has been closed meanwhile. Let's re-create it.");
            this.closeWebDriver();
            webDriver = this.createDriver();
        } else if (webDriver == null) {
            log.info("No webdriver is bound to current thread: {} - let's create a new webdriver", (Object)Thread.currentThread().getId());
            webDriver = this.createDriver();
        }
        return webDriver;
    }

    @Override
    @Nonnull
    public DownloadsFolder getBrowserDownloadsFolder() {
        return this.threadDownloadsFolder.get(Thread.currentThread().getId());
    }

    @CheckReturnValue
    @Nonnull
    private WebDriver createDriver() {
        CreateDriverCommand.Result result = this.createDriverCommand.createDriver(this.config, this.factory, this.userProvidedProxy, this.eventListeners, this.listeners);
        long threadId = Thread.currentThread().getId();
        this.threadWebDriver.put(threadId, result.webDriver);
        if (result.selenideProxyServer != null) {
            this.threadProxyServer.put(threadId, result.selenideProxyServer);
        }
        if (result.browserDownloadsFolder != null) {
            this.threadDownloadsFolder.put(threadId, result.browserDownloadsFolder);
        }
        if (this.config.holdBrowserOpen()) {
            log.info("Browser and proxy will stay open due to holdBrowserOpen=true: {} -> {}, {}", new Object[]{threadId, result.webDriver, result.selenideProxyServer});
        } else {
            this.markForAutoClose(Thread.currentThread());
        }
        return result.webDriver;
    }

    @Override
    @CheckReturnValue
    @Nullable
    public SelenideProxyServer getProxyServer() {
        return this.threadProxyServer.get(Thread.currentThread().getId());
    }

    @Override
    public void closeWindow() {
        this.getWebDriver().close();
    }

    @Override
    public void closeWebDriver() {
        long threadId = Thread.currentThread().getId();
        WebDriver driver = this.threadWebDriver.get(threadId);
        SelenideProxyServer proxy = this.threadProxyServer.get(threadId);
        this.closeDriverCommand.close(this.config, driver, proxy);
        this.resetWebDriver();
    }

    @Override
    public void clearBrowserCache() {
        if (this.hasWebDriverStarted()) {
            this.getWebDriver().manage().deleteAllCookies();
        }
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getPageSource() {
        return this.getWebDriver().getPageSource();
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getCurrentUrl() {
        return this.getWebDriver().getCurrentUrl();
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getCurrentFrameUrl() {
        return Selenide.executeJavaScript("return window.location.href", new Object[0]).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markForAutoClose(Thread thread) {
        this.allWebDriverThreads.add(thread);
        if (!this.cleanupThreadStarted.get()) {
            WebDriverThreadLocalContainer webDriverThreadLocalContainer = this;
            synchronized (webDriverThreadLocalContainer) {
                if (!this.cleanupThreadStarted.get()) {
                    new UnusedWebdriversCleanupThread(this.allWebDriverThreads, this.threadWebDriver, this.threadProxyServer, this.threadDownloadsFolder).start();
                    this.cleanupThreadStarted.set(true);
                }
            }
        }
    }
}

