/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import com.codeborne.selenide.webdriver.CdpClient;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.File;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.opera.OperaDriverService;
import org.openqa.selenium.opera.OperaOptions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.service.DriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class OperaDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(OperaDriverFactory.class);
    private final CdpClient cdpClient = new CdpClient();

    @Override
    public void setupWebdriverBinary() {
        if (this.isSystemPropertyNotSet("webdriver.opera.driver")) {
            WebDriverManager.operadriver().setup();
        }
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebDriver create(Config config, Browser browser, @Nullable Proxy proxy, File browserDownloadsFolder) {
        OperaDriverService driverService = this.createDriverService(config);
        OperaOptions capabilities = this.createCapabilities(config, browser, proxy, browserDownloadsFolder);
        OperaDriver driver = new OperaDriver(driverService, capabilities);
        this.cdpClient.setDownloadsFolder((DriverService)driverService, (RemoteWebDriver)driver, browserDownloadsFolder);
        return driver;
    }

    private OperaDriverService createDriverService(Config config) {
        return (OperaDriverService)((OperaDriverService.Builder)new OperaDriverService.Builder().withLogFile(this.webdriverLog(config))).build();
    }

    @CheckReturnValue
    @Nonnull
    public OperaOptions createCapabilities(Config config, Browser browser, @Nullable Proxy proxy, File browserDownloadsFolder) {
        OperaOptions operaOptions = new OperaOptions();
        if (config.headless()) {
            throw new InvalidArgumentException("headless browser not supported in Opera. Set headless property to false.");
        }
        if (!config.browserBinary().isEmpty()) {
            log.info("Using browser binary: {}", (Object)config.browserBinary());
            operaOptions.setBinary(config.browserBinary());
        }
        operaOptions.merge((Capabilities)this.createCommonCapabilities(config, browser, proxy));
        return operaOptions;
    }
}

