/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.files.FileFilter;
import com.codeborne.selenide.impl.Waiter;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.impl.WindowsCloser;
import com.codeborne.selenide.proxy.FileDownloadFilter;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DownloadFileWithProxyServer {
    private static final Logger log = LoggerFactory.getLogger(DownloadFileWithProxyServer.class);
    private final Waiter waiter;
    private final WindowsCloser windowsCloser;

    DownloadFileWithProxyServer(Waiter waiter, WindowsCloser windowsCloser) {
        this.waiter = waiter;
        this.windowsCloser = windowsCloser;
    }

    public DownloadFileWithProxyServer() {
        this(new Waiter(), new WindowsCloser());
    }

    @CheckReturnValue
    @Nonnull
    public File download(WebElementSource anyClickableElement, WebElement clickable, long timeout, FileFilter fileFilter) throws FileNotFoundException {
        WebDriver webDriver = anyClickableElement.driver().getWebDriver();
        return this.windowsCloser.runAndCloseArisedWindows(webDriver, () -> this.clickAndInterceptFileByProxyServer(anyClickableElement, clickable, timeout, fileFilter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private File clickAndInterceptFileByProxyServer(WebElementSource anyClickableElement, WebElement clickable, long timeout, FileFilter fileFilter) throws FileNotFoundException {
        Config config = anyClickableElement.driver().config();
        if (!config.proxyEnabled()) {
            throw new IllegalStateException("Cannot download file: proxy server is not enabled. Setup proxyEnabled");
        }
        SelenideProxyServer proxyServer = anyClickableElement.driver().getProxy();
        if (proxyServer == null) {
            throw new IllegalStateException("Cannot download file: proxy server is not started");
        }
        FileDownloadFilter filter = (FileDownloadFilter)proxyServer.responseFilter("download");
        if (filter == null) {
            throw new IllegalStateException("Cannot download file: download filter is not activated");
        }
        filter.activate();
        try {
            this.waiter.wait(filter, new PreviousDownloadsCompleted(), timeout, config.pollingInterval());
            filter.reset();
            clickable.click();
            this.waiter.wait(filter, new HasDownloads(fileFilter), timeout, config.pollingInterval());
            if (log.isInfoEnabled()) {
                log.info(filter.downloads().filesAsString());
                log.info("Just in case, all intercepted responses: {}", (Object)filter.responsesAsString());
            }
            File file = filter.downloads().firstDownloadedFile(anyClickableElement.toString(), timeout, fileFilter);
            return file;
        }
        finally {
            filter.deactivate();
        }
    }

    @ParametersAreNonnullByDefault
    private static class PreviousDownloadsCompleted
    implements Predicate<FileDownloadFilter> {
        private int downloadsCount = -1;

        private PreviousDownloadsCompleted() {
        }

        @Override
        public boolean test(FileDownloadFilter filter) {
            try {
                boolean bl = this.downloadsCount == filter.downloads().size();
                return bl;
            }
            finally {
                this.downloadsCount = filter.downloads().size();
            }
        }
    }

    @ParametersAreNonnullByDefault
    private static class HasDownloads
    implements Predicate<FileDownloadFilter> {
        private final FileFilter fileFilter;

        private HasDownloads(FileFilter fileFilter) {
            this.fileFilter = fileFilter;
        }

        @Override
        public boolean test(FileDownloadFilter filter) {
            return !filter.downloads().files(this.fileFilter).isEmpty();
        }
    }
}

