/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.ClickMethod;

public class ClickOptions {
    private final int offsetX;
    private final int offsetY;
    private final ClickMethod clickMethod;

    private ClickOptions(ClickMethod clickMethod, int offsetX, int offsetY) {
        this.clickMethod = clickMethod;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public static ClickOptions usingDefaultMethod() {
        return new ClickOptions(ClickMethod.DEFAULT, 0, 0);
    }

    public static ClickOptions usingJavaScript() {
        return new ClickOptions(ClickMethod.JS, 0, 0);
    }

    public int offsetX() {
        return this.offsetX;
    }

    public int offsetY() {
        return this.offsetY;
    }

    public ClickMethod clickOption() {
        return this.clickMethod;
    }

    public ClickOptions offsetX(int offsetX) {
        return new ClickOptions(this.clickMethod, offsetX, this.offsetY);
    }

    public ClickOptions offsetY(int offsetY) {
        return new ClickOptions(this.clickMethod, this.offsetX, offsetY);
    }

    public ClickOptions offset(int offsetX, int offsetY) {
        return new ClickOptions(this.clickMethod, offsetX, offsetY);
    }
}

