/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.ex.ElementWithTextNotFound;
import com.codeborne.selenide.impl.WebElementsCollection;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.WebElement;

public class ItemWithText
extends CollectionCondition {
    private final String expectedText;

    public ItemWithText(String expectedText) {
        this.expectedText = expectedText;
    }

    @Override
    public boolean test(List<WebElement> elements) {
        return ElementsCollection.texts(elements).contains(this.expectedText);
    }

    @Override
    public void fail(WebElementsCollection collection, List<WebElement> elements, Exception lastError, long timeoutMs) {
        throw new ElementWithTextNotFound(collection, ElementsCollection.texts(elements), Collections.singletonList(this.expectedText), this.explanation, timeoutMs);
    }

    @Override
    public boolean applyNull() {
        return false;
    }

    public String toString() {
        return "Text " + this.expectedText;
    }
}

