/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.proxy;

import java.io.File;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DownloadedFile {
    private final File file;
    private final long lastModifiedAt;
    private final Map<String, String> headers;

    public DownloadedFile(File file, Map<String, String> headers) {
        this.file = file;
        this.lastModifiedAt = file.lastModified();
        this.headers = headers;
    }

    @CheckReturnValue
    @Nonnull
    public File getFile() {
        return this.file;
    }

    @CheckReturnValue
    public boolean hasContentDispositionHeader() {
        return this.headers.containsKey("content-disposition");
    }

    @Nullable
    public String getContentType() {
        return this.headers.get("content-type");
    }

    public int hashCode() {
        return 31 * this.file.hashCode() + Long.hashCode(this.lastModifiedAt);
    }

    public boolean equals(Object obj) {
        return obj instanceof DownloadedFile && this.equals((DownloadedFile)obj);
    }

    private boolean equals(DownloadedFile other) {
        return this.file.equals(other.file) && this.lastModifiedAt == other.lastModifiedAt;
    }
}

