/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.WebElementsCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class WebElementsCollectionWrapper
implements WebElementsCollection {
    private final List<WebElement> elements;
    private final Driver driver;

    public WebElementsCollectionWrapper(Driver driver, Collection<? extends WebElement> elements) {
        this.driver = driver;
        this.elements = new ArrayList<WebElement>(elements);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public List<WebElement> getElements() {
        return this.elements;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String description() {
        return "$$(" + this.elements.size() + " elements)";
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Driver driver() {
        return this.driver;
    }
}

